<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/file_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

$exptype = $_POST['exptype'];
if ($exptype == 1 && $_POST['user_id'] == 0)
{
	$exptype = 3;
}

switch ($exptype)
{
	case 1: // prestations par utilisateur
		$user_id = $_POST['user_id'];
		$sql = "SELECT * FROM prestations, projets, domaines, taches, produits, lieux, deplacements, zones WHERE prestations.pre_fk_user = $user_id AND prestations.pre_fk_projet = projets.proj_id AND domaines.dom_id = prestations.pre_fk_domaine AND taches.tache_id = prestations.pre_fk_tache AND produits.prod_id = prestations.pre_fk_produit AND lieux.lieu_id = prestations.pre_fk_lieu AND deplacements.depl_id = prestations.pre_fk_deplacement AND zones.zone_id = prestations.pre_fk_zone ORDER BY pre_date;";
		$tab[] = "Date,Projet,Description,Heures,Domaine,Tche,Produit,Lieu,Dplacement,Zone";
		$req = Requete ($sql, $conn);
		while ($rs = ObjetSuivant($req))
		{
			$tab[] = "$rs->pre_date,".html_entity_decode($rs->proj_titre_abr).",".html_entity_decode(str_replace(","," -",$rs->pre_desc)).",$rs->pre_heures,".html_entity_decode($rs->dom_nom).",".html_entity_decode($rs->tache_nom).",".html_entity_decode($rs->prod_nom).",".html_entity_decode($rs->lieu_nom).",".html_entity_decode($rs->depl_nom).",".html_entity_decode($rs->zone_nom);
		}
		break;
	case 2: // prestations par projet
		$proj_id = $_POST['proj_id'];
		$sql = "SELECT * FROM prestations, users, domaines, taches, produits, lieux, deplacements, zones WHERE prestations.pre_fk_projet = $proj_id AND prestations.pre_fk_user = users.user_id AND domaines.dom_id = prestations.pre_fk_domaine AND taches.tache_id = prestations.pre_fk_tache AND produits.prod_id = prestations.pre_fk_produit AND lieux.lieu_id = prestations.pre_fk_lieu AND deplacements.depl_id = prestations.pre_fk_deplacement AND zones.zone_id = prestations.pre_fk_zone ORDER BY pre_date;";
		$tab[] = "Date,Prestataire,Description,Heures,Domaine,Tche,Produit,Lieu,Dplacement,Zone";
		$req = Requete ($sql, $conn);
		while ($rs = ObjetSuivant($req))
		{
			$tab[] = "$rs->pre_date,".html_entity_decode($rs->user_prenom)." ".html_entity_decode($rs->user_nom).",".html_entity_decode(str_replace(","," -",$rs->pre_desc)).",$rs->pre_heures,".html_entity_decode($rs->dom_nom).",".html_entity_decode($rs->tache_nom).",".html_entity_decode($rs->prod_nom).",".html_entity_decode($rs->lieu_nom).",".html_entity_decode($rs->depl_nom).",".html_entity_decode($rs->zone_nom);
		}
		break;
	case 3: // toutes les prestations
		$sql = "SELECT * FROM prestations, projets, domaines, taches, produits, users, lieux, deplacements, zones WHERE prestations.pre_fk_user = users.user_id AND prestations.pre_fk_projet = projets.proj_id AND prestations.pre_fk_projet = projets.proj_id AND domaines.dom_id = prestations.pre_fk_domaine AND taches.tache_id = prestations.pre_fk_tache AND produits.prod_id = prestations.pre_fk_produit AND lieux.lieu_id = prestations.pre_fk_lieu AND deplacements.depl_id = prestations.pre_fk_deplacement AND zones.zone_id = prestations.pre_fk_zone ORDER BY pre_date;";
		$tab[] = "Date,Prestataire,Projet,Description,Heures,Domaine,Tche,Produit,Lieu,Dplacement,Zone";
		$req = Requete ($sql, $conn);
		while ($rs = ObjetSuivant($req))
		{
			$tab[] = "$rs->pre_date,".html_entity_decode($rs->user_prenom)." ".html_entity_decode($rs->user_nom).",".html_entity_decode($rs->proj_titre_abr).",".html_entity_decode(str_replace(","," -",$rs->pre_desc)).",$rs->pre_heures,".html_entity_decode($rs->dom_nom).",".html_entity_decode($rs->tache_nom).",".html_entity_decode($rs->prod_nom).",".html_entity_decode($rs->lieu_nom).",".html_entity_decode($rs->depl_nom).",".html_entity_decode($rs->zone_nom);
		}
		break;
	case 4: // statistiques
		$tab = unserialize(stripslashes($_POST['tabstats']));
		break;
}

$csv_fichier = "phpdaily_prestations_".date('Y_m_d_H_i').".csv";
$file = "datafiles/".$csv_fichier;

$fp = fopen($file, 'w');
foreach ($tab as $line)
{
	fputcsv($fp, split(',', $line),';');
}
fclose($fp);

$sql = "SELECT * FROM fichiers_csv ORDER BY csv_id DESC LIMIT 1;";
$req = Requete ($sql, $conn);
$ok = FALSE;
while ($rs = ObjetSuivant($req))
{
	$csv_id = $rs->csv_id + 1;
	$ok = TRUE;
}
if (!$ok)
{
	$csv_id = 1;
}

$sql = "INSERT INTO fichiers_csv (csv_id,csv_date,csv_type,csv_fichier) VALUES ($csv_id,'".date('Y-m-d')."',$exptype,'$csv_fichier');";
$req = Requete ($sql,$conn);
?>

<div class="content">

	<h2>
		Donn&eacute;es export&eacute;es
		<br />
		Cliquez sur l'ic&ocirc;ne pour t&eacute;l&eacute;charger le fichier
	</h2>
	
	<h2><a href="download_file.php?fichier=<?php echo $csv_fichier; ?>"><img src="images/dl_file.gif" border="0"></a></h2>

</div>

<?php
require_once ('include/footer.php');
?>