<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

if (isset($_GET['mode']))
{
	$mode = $_GET['mode'];
}
else
{
	$mode = "";
}

if (isset($_GET['order']))
{
	$order = $_GET['order'];
}
else
{
	$order = "num";
}

switch ($order)
{
	case 'tit':
		$orderby = "proj_titre_abr";
		break;
	case 'num':
		$orderby = "proj_num";
		break;
	default:
		$orderby = "proj_num";
		break;
}
?>

<div class="content">

<?php
require_once ("include/checklevel.php");
?>

	<p>
		<a href="add_projet.php"><?php echo TXT_PROJET_NOUVEAU_PROJET; ?></a><br />
<?php
if ($mode == 'arch')
{
?>
		<a href="projets.php"><?php echo TXT_PROJET_AFFICHER_ACTIFS; ?></a><br />
<?php
}
else
{
?>
		<a href="projets.php?mode=arch"><?php echo TXT_PROJET_AFFICHER_ARCHIVES; ?></a><br />
<?php	
}
if ($_SESSION['conf_domaines'])
{
?>
		<a href="match_projet_domaine.php"><?php echo TXT_MULTICAT_DOMAINES_DES_PROJETS; ?></a>
<?php
}
?>
	</p>
	
<?php
if ($mode == 'arch')
{
	$sql = "SELECT * FROM projets WHERE proj_isarchive = 1 ORDER BY $orderby;";
	echo "<h2>".TXT_PROJETS_PROJETS_ARCHIVES."</h2>\n";
}
else
{
	$sql = "SELECT * FROM projets WHERE proj_isarchive = 0 ORDER BY $orderby;";
	echo "<h2>".TXT_PROJETS_PROJETS_ACTIFS."</h2>\n";
}
$req = Requete ($sql,$conn);

if (NombreLignes($req) > 0)
{
?>

	<table border="0" align="center" cellpadding="3" cellspacing="0">
		<tr>
			<th><a href="projets.php?order=num" title="Trier par num&eacute;ros"><?php echo TXT_PROJETS_NUMERO; ?></a></th>
			<th><a href="projets.php?order=tit" title="Trier par noms"><?php echo TXT_PROJET_PROJET; ?></a></th>
			<th><?php echo TXT_PROJETS_ACTIONS; ?></th>
		</tr>
		
<?php
	$count = 0;
	while ($rs = ObjetSuivant($req))
	{
		$count += 1;
		if ($count % 2 > 0)
		{
			$class = "data1";
		}
		else
		{
			$class = "data2";
		}
		echo "<tr class=\"".$class."\">\n";
		echo "<td>".$rs->proj_num."</td>\n";
		echo "<td><a href=\"proj_detail.php?id=".$rs->proj_id."\">".$rs->proj_titre_abr."</a></td>\n";
		echo "<td class=\"cellright\">";
		if ($mode != 'arch')
		{
			echo "<a href=\"mod_projet.php?id=".$rs->proj_id."\"><img src=\"images/b_edit.gif\" border=\"0\" alt=\"".TXT_PROJETS_MODIFIER."\" title=\"".TXT_PROJETS_MODIFIER."\"></a>&nbsp;";
		}
		echo "<a href=\"delete.php?mode=projet&id=".$rs->proj_id."\"><img src=\"images/b_drop.gif\" border=\"0\" alt=\"".TXT_PROJETS_SUPPRIMER."\" title=\"".TXT_PROJETS_SUPPRIMER."\"></a>";
		echo "<a href=\"process_projet.php?cas=arch&id=".$rs->proj_id."\"><img src=\"images/b_arch.png\" border=\"0\" ";
		if ($mode == 'arch')
		{
			echo "alt=\"".TXT_PROJETS_RETIRER_DES_ARCHIVES."\" title=\"".TXT_PROJETS_RETIRER_DES_ARCHIVES."\">";
		}
		else
		{
			echo "alt=\"".TXT_PROJETS_ARCHIVER."\" title=\"".TXT_PROJETS_ARCHIVER."\">";
		}
		echo "</a>";
		echo "</td>\n";
		echo "</tr>\n";
	}
	echo "</table>\n";
}
else
{
	echo "<p>".TXT_PROJET_AUCUN_PROJET_POUR_LE_MOMENT."</p>\n";
}
?>

<br />

</div>

<?php
require_once ('include/footer.php');
?>