<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header_impr.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

if (isset($_GET['mode']))
{
	$mode = $_GET['mode'];
}
else
{
	$mode = "normal";
}

if (isset($_GET['user_id']))
{
	$user_id = $_GET['user_id'];
}
else
{
	$user_id = $_SESSION['userid'];
}

$req = Requete ("SELECT * FROM users WHERE user_id = $user_id;",$conn);

while ($rs = ObjetSuivant($req))
{
	$user_nom = $rs->user_nom;
	$user_prenom = $rs->user_prenom;
}

$periode_titre = "depuis ";

if (isset($_GET['periode']))
{
	switch ($_GET['periode'])
	{
		case 1:
			$periode = "AND YEAR(pre_date) = ".date('Y')." AND MONTH(pre_date) = ".date('m');
			$periode_titre .= "le d&eacute;but du mois : ".NomDuMois(date('m'))." ".date('Y');
			break;
		case 2:
			$periode = "AND DATEDIFF(NOW(),pre_date) < 93";
			$periode_titre .= MoisMoinsTrois(date('m'),date('Y'));
			break;
		case 3:
			$periode = "AND YEAR(pre_date) = ".date('Y');
			$periode_titre .= "le d&eacute;but de cette ann&eacute;e : ".date('Y');
			break;
		case 4:
			$periode = "";
			$periode_titre = "(toutes)";
			break;
		default:
			$periode = "";
			$periode_titre = "(toutes)";
			break;
	}
}
else
{
	$periode = "";
}
?>

<div class="content">
	
<?php
if ($mode == 'all_users')
{
	echo "<h2>Toutes les prestations<br />$periode_titre</h2>\n";
	$sql = "SELECT * FROM prestations, projets, ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "taches, ";
	}
	$sql .= "lieux, users WHERE prestations.pre_fk_projet = projets.proj_id ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "AND prestations.pre_fk_tache = taches.tache_id ";
	}
	$sql .= "AND lieux.lieu_id = prestations.pre_fk_lieu AND users.user_id = prestations.pre_fk_user $periode ORDER BY pre_date DESC;";
}
else
{
	echo "<h2>prestations de $user_prenom $user_nom<br />$periode_titre</h2>\n";
	$sql = "SELECT * FROM prestations, projets, ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "taches, ";
	}
	$sql .= "lieux WHERE prestations.pre_fk_user = $user_id AND prestations.pre_fk_projet = projets.proj_id ";
	if ($_SESSION['conf_taches'])
	{
		$sql .= "AND prestations.pre_fk_tache = taches.tache_id ";
	}
	$sql .= "AND lieux.lieu_id = prestations.pre_fk_lieu $periode ORDER BY pre_date DESC;";
}
$req = Requete ($sql,$conn);

if (NombreLignes($req) > 0)
{
?>

	<table class="impr" border="0" width="100%" align="center" cellpadding="3" cellspacing="0">
		<tr class="impr">
			<th>Date</th>
<?php
if ($mode == 'all_users')
{
	echo "<th>Nom</th>\n";
}
?>
			<th>Lieu</th>
			<th><?php echo TXT_PROJET_PROJET; ?></th>
<?php
if ($_SESSION['conf_taches'])
{
?>
			<th><?php echo TXT_TACHE_TACHE; ?></th>
<?php
}
?>
			<th>Heures</th>
			<th>A fait quoi ?</th>
		</tr>
		
<?php
	$count = 0;
	while ($rs = ObjetSuivant($req))
	{
		$count += 1;
		if ($count % 2 > 0)
		{
			$class = "data1";
		}
		else
		{
			$class = "data2";
		}
		echo "<tr class=\"".$class."\">\n";
		echo "<td>".day_month_year($rs->pre_date)."</td>\n";
		if ($mode == 'all_users')
		{
			echo "<td>".$rs->user_prenom." ".$rs->user_nom."</td>\n";
		}
		echo "<td>".$rs->lieu_nom."</td>\n";
		echo "<td>".$rs->proj_titre_abr."</td>\n";
		if ($_SESSION['conf_taches'])
		{
			echo "<td>".$rs->tache_nom."</td>\n";
		}
		echo "<td>".heures($rs->pre_heures)."</td>\n";
		if (is_null($rs->pre_desc))
		{
			echo "<td>&nbsp;</td>\n";
		}
		else
		{
			echo "<td>".$rs->pre_desc."</td>\n";
		}
		echo "</tr>\n";
	}
	echo "</table>\n";
}
else
{
	echo "<p>Aucune prestation encod&eacute;e pour le moment.</p>\n";
}
?>

<br />

</div>

<?php
require_once ('include/footer.php');
?>