<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

if (isset($_GET['id']))
{
	$id_field = $_GET['id'];
}
else
{
	$id_field = $_POST['pre_id'];
}
$prev = $_GET['prev'];
if (isset($_GET['pdate']))
{
	$pdate = $_GET['pdate'];
	$pdate_get = "&pdate=";
}
else
{
	$pdate = "";
	$pdate_get = "";
}

$args = "prev=".$prev.$pdate_get.$pdate;

echo "<div class=\"content\">\n";

if (!isset($_POST['form_mode']))
{
	$req = Requete ("SELECT * FROM prestations WHERE pre_id = $id_field;",$conn);

	while ($rs = ObjetSuivant($req))
	{
		$date = $_SESSION['ses_pre_date'];
		$pre_desc = $rs->pre_desc;
		$user_id = $rs->pre_fk_user;
		$lieu_id = $rs->pre_fk_lieu;
		$zone_id = $rs->pre_fk_zone;
		$depl_id = $rs->pre_fk_deplacement;
		$prod_id = $rs->pre_fk_produit;
		$pre_heures = $rs->pre_heures;
		$proj_id = $rs->pre_fk_projet;
		$dom_id = $rs->pre_fk_domaine;
		$_SESSION['ses_proj_id'] = $rs->pre_fk_projet;
		$_SESSION['ses_dom_id'] = $rs->pre_fk_domaine;
		$tache_id = $rs->pre_fk_tache;
		$pre_remarques = $rs->pre_remarques;
	}
}
else
{
	$id_field = $_POST['pre_id'];
	$date = $_SESSION['ses_pre_date'];
	$user_id = $_POST['user_id'];
	if (strlen($_POST['pre_desc']) > 0)
	{
		$pre_desc = htmlentities($_POST['pre_desc']);
	}
	else
	{
		$pre_desc = "";
	}
	if (strlen($_POST['pre_remarques']) > 0)
	{
		$pre_remarques = htmlentities($_POST['pre_remarques']);
	}
	else
	{
		$pre_remarques = "";
	}
	$lieu_id = $_POST['lieu_id'];
	if (isset($_POST['zone_id']))
	{
		$zone_id = $_POST['zone_id'];
	}
	if (isset($_POST['depl_id']))
	{
		$depl_id = $_POST['depl_id'];
	}
	if (isset($_POST['prod_id']))
	{
		$prod_id = $_POST['prod_id'];
	}
	$pre_heures = $_POST['pre_heures'];
	$proj_id = $_POST['proj_id'];
	if (isset($_POST['dom_id']))
	{
		$dom_id = $_POST['dom_id'];
	}
	if (isset($_POST['tache_id']))
	{
		$tache_id = $_POST['tache_id'];
	}
	
	// -----------------------------------------------
	// Reset des champs de formulaire si changement de projet ou de domaine !
	if ($proj_id != $_SESSION['ses_proj_id'])
	{
		$dom_id = 0;
		$tache_id = 0;
	}
	if ($dom_id != $_SESSION['ses_dom_id'])
	{
		$tache_id = 0;
	}
	// -----------------------------------------------
	
	$_SESSION['ses_proj_id'] = $proj_id;
	$_SESSION['ses_dom_id'] = $dom_id;
	
	if ($_POST['form_mode'] == '0')
	{
		$error = FALSE;
		
		if ($pre_heures == "" || $proj_id < 1 || ($_SESSION['conf_domaines'] && $dom_id < 1) || ($_SESSION['conf_taches'] && $tache_id < 1))
		{
			$error = TRUE;
			$err_msg = "<h4 class=\"error\">".TXT_ADD_PRESTATION_VOUS_AVEZ_OUBLIE_CHAMPS_OBLIGATOIRES."</h4>\n";
		}
		
		if ($error)
		{
			echo $err_msg;
		}
		else
		{
			$sql = "UPDATE prestations SET pre_fk_projet=$proj_id,";
			if ($_SESSION['conf_domaines'])
			{
				$sql .= "pre_fk_domaine=$dom_id,";
			}
			if ($_SESSION['conf_taches'])
			{
				$sql .= "pre_fk_tache=$tache_id,";
			}
			if ($_SESSION['conf_deplacements'])
			{
				$sql .= "pre_fk_deplacement=$depl_id,";
			}
			if ($_SESSION['conf_produits'])
			{
				$sql .= "pre_fk_produit=$prod_id,";
			}
			if ($_SESSION['conf_zones'])
			{
				$sql .= "pre_fk_zone=$zone_id,";
			}
			$sql .= "pre_date='$date',pre_heures=$pre_heures,pre_fk_lieu=$lieu_id,";
			$sql .= "pre_desc='$pre_desc',pre_remarques='$pre_remarques' ";
			$sql .= "WHERE pre_id = $id_field;";
			$req = Requete ($sql, $conn);
			
			unset($_SESSION['ses_proj_id'], $_SESSION['ses_dom_id'], $_SESSION['ses_pre_date']);
			
			echo "<h2>".TXT_MOD_PRESTATION_PRESTATION_MODIFIEE."</h2>\n";
			switch ($prev)
			{
				case 'new':
					$lien = "add_prestation.php?date=$pdate";
					break;
				case 'list' :
					$lien = "prestations.php";
					break;
				default :
					$lien = "prestations.php";
					break;
			}
			echo "<h2><input type=\"button\" class=\"bouton\" value=\"".TXT_MOD_PRESTATION_RETOUR."\" onClick=\"javascript:document.location.href='$lien';\"></h2><br />\n";
			echo "</div>";
			require_once ('include/footer.php');
			exit;
		}
	}
}

?>
	
	<h2><?php echo TXT_MOD_PRESTATIONS_MODIFIER_PRESTATION; ?></h2>

	<form name="mod_prestation" action="mod_prestation.php?<?php echo $args; ?>&mode=check" method="post" onSubmit="this['form_mode'].value='0';">
		<input type="hidden" name="form_mode" value="reload">
		<input type="hidden" name="pre_id" value="<?php echo $id_field; ?>">
		<input type="hidden" name="user_id" value="<?php echo $user_id; ?>">
	
		<table width="80%" align="center" cellpadding="3" cellspacing="3">
			<tr>
				<th colspan="2"><?php echo TXT_MOD_PREST_DATE_ETAPE_2_MODIF_DETAILS; ?></th>
			</tr>
			<tr>
				<td class="cellright"><?php echo TXT_MOD_PRESTATIONS_QUAND; ?></td>
				<td class="cellleft"><?php echo day_month_year($date); ?></td>
			</tr>
			<tr>
				<td class="cellright"><?php echo TXT_MOD_PRESTATIONS_QUI; ?></td>
				<td class="cellleft">
<?php
$req = Requete ("SELECT * FROM users WHERE user_id = $user_id;",$conn);
while ($rs = ObjetSuivant($req))
{
	echo $rs->user_prenom." ".$rs->user_nom;
}
?>
				</td>
			</tr>
			<tr>
				<td class="cellright" valign="top"><?php echo TXT_MOD_PRESTATIONS_A_FAIT_QUOI; ?></td>
				<td class="cellleft"><textarea name="pre_desc" cols="50" rows="5"><?php echo $pre_desc; ?></textarea></td>
			</tr>
			<tr>
				<td class="cellright"><?php echo TXT_MOD_PRESTATIONS_OU; ?></td>
				<td class="cellleft">
					<select name="lieu_id">
					
<?php
$req = Requete ("SELECT * FROM lieux ORDER BY lieu_nom;",$conn);
while ($rs = ObjetSuivant($req))
{
	echo "<option value=\"".$rs->lieu_id."\"";
	if ($rs->lieu_id == $lieu_id)
	{
		echo " selected";
	}
	echo ">".$rs->lieu_nom."</option>\n";
}
?>
					
					</select>
<?php
if ($_SESSION['conf_deplacements'])
{
?>
					<select name="depl_id">
					
<?php
	$req = Requete ("SELECT * FROM deplacements ORDER BY depl_id;",$conn);
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"".$rs->depl_id."\"";
		if ($rs->depl_id == $depl_id)
		{
			echo " selected";
		}
		echo ">".$rs->depl_nom."</option>\n";
	}
?>
					
					</select>
<?php
}
else
{
	echo "<input type=\"hidden\" name=\"depl_id\" value=\"".$depl_id."\">";
}
?>
				</td>
			</tr>
<?php
if ($_SESSION['conf_zones'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_MOD_PRESTATIONS_POUR_QUEL_REGROUPEMENT; ?></td>
				<td class="cellleft">
					<select name="zone_id">
					
<?php
	$req = Requete ("SELECT * FROM zones WHERE zone_isactive = 1 ORDER BY zone_ordre;",$conn);
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"".$rs->zone_id."\"";
		if ($rs->zone_id == $zone_id)
		{
			echo " selected";
		}
		echo ">".$rs->zone_nom."</option>\n";
	}
?>
					
					</select>
				</td>
			</tr>
<?php
}
else
{
	echo "<input type=\"hidden\" name=\"zone_id\" value=\"".$zone_id."\">";
}
if ($_SESSION['conf_produits'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_MOD_PRESTATIONS_SUR_QUEL_PRODUIT; ?></td>
				<td class="cellleft">
					<select name="prod_id">
					
<?php
	$req = Requete ("SELECT * FROM produits ORDER BY prod_nom;",$conn);
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"".$rs->prod_id."\"";
		if ($rs->prod_id == $prod_id)
		{
			echo " selected";
		}
		echo ">".$rs->prod_nom."</option>\n";
	}
?>
					
					</select>
				</td>
			</tr>
<?php
}
else
{
	echo "<input type=\"hidden\" name=\"prod_id\" value=\"".$prod_id."\">";
}
?>
			<tr>
				<td class="cellright"><?php echo TXT_MOD_PRESTATIONS_PENDANT_COMBIEN_TEMPS; ?></td>
				<td class="cellleft"><input type="text" class="gen" name="pre_heures" value="<?php echo $pre_heures; ?>"size="5"> <span class="tablecomment"><?php echo TXT_MOD_PRESTATION_EXEMPLES; ?></span></td>
			</tr>
			<tr>
				<td class="cellright"><?php echo TXT_PROJET_POUR_QUEL_PROJET; ?> * </td>
				<td class="cellleft">
					<select name="proj_id"<?php if($_SESSION['conf_domaines']){ ?> onChange="javascript:document.forms[0].form_mode.value='1';document.forms[0].submit();"<?php } ?>>

<?php
echo "<option value=\"0\"";
if ($proj_id == 0)
{
	echo " selected";
}
echo ">--".TXT_PROJET_CHOISISSEZ_UN_PROJET."--</option>\n";
$req = Requete ("SELECT * FROM projets WHERE proj_isarchive = 0 ORDER BY proj_titre_abr;",$conn);
while ($rs = ObjetSuivant($req))
{
	echo "<option value=\"$rs->proj_id\"";
	if ($rs->proj_id == $proj_id)
	{
		echo " selected";
	}
	echo ">$rs->proj_titre_abr</option>\n";
}
?>

					</select>
				</td>
			</tr>
<?php
if ($_SESSION['conf_domaines'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_DOMAINE_POUR_QUEL_DOMAINE; ?> * </td>
				<td class="cellleft">

<?php
	echo "<select name=\"dom_id\"";
	if ($_SESSION['conf_taches'])
	{
		echo " onChange=\"javascript:document.forms[0].form_mode.value='2';document.forms[0].submit();\"";
	}
	if ($proj_id > 0)
	{
		echo ">\n";
		echo "<option value=\"0\"";
		if ($dom_id == 0)
		{
			echo " selected";
		}
		echo ">--".TXT_DOMAINE_CHOISISSEZ_UN_DOMAINE."--</option>\n";
		$sql = "SELECT * FROM proj_dom, domaines WHERE pd_fk_projet = $proj_id AND proj_dom.pd_fk_domaine = domaines.dom_id AND NOT (domaines.dom_id = 0) ORDER BY dom_id;";
		$req = Requete ($sql,$conn);
		while ($rs = ObjetSuivant($req))
		{
			echo "<option value=\"$rs->dom_id\"";
			if ($rs->dom_id == $dom_id)
			{
				echo " selected";
			}
			echo ">$rs->dom_id $rs->dom_nom</option>\n";
		}
	}
	else
	{
		echo " disabled>\n";
		echo "<option value=\"0\">--".TXT_PROJET_CHOISISSEZ_D_ABORD_UN_PROJET."--</option>\n";
	}
?>

					</select>
				</td>
			</tr>
<?php
}
if ($_SESSION['conf_taches'])
{
?>
			<tr>
				<td class="cellright"><?php echo TXT_TACHE_POUR_QUELLE_TACHE; ?> * </td>
				<td class="cellleft">

<?php
	echo "<select name=\"tache_id\"";
	if ($_SESSION['conf_domaines'])
	{
		$req = Requete ("SELECT * FROM dom_taches, taches WHERE dom_taches.dt_fk_domaine = $dom_id AND dom_taches.dt_fk_tache = taches.tache_id AND NOT (taches.tache_id = 0) ORDER BY tache_nom;",$conn);
		if ($dom_id > 0)
		{
			echo ">\n";
			echo "<option value=\"0\"";
			if ($tache_id == 0)
			{
				echo " selected";
			}
			echo ">--".TXT_TACHE_CHOISISSEZ_UNE_TACHE."--</option>\n";
		}
		else
		{
			echo " disabled>\n";
			echo "<option value=\"0\" selected>--".TXT_DOMAINE_CHOISISSEZ_D_ABORD_UN_DOMAINE."--</option>\n";
		}
	}
	else
	{
		$req = Requete ("SELECT * FROM taches WHERE NOT (tache_id = 0) ORDER BY tache_nom;",$conn);
		echo ">\n";
	}
	while ($rs = ObjetSuivant($req))
	{
		echo "<option value=\"$rs->tache_id\"";
		if ($rs->tache_id == $tache_id)
		{
			echo " selected";
		}
		echo ">$rs->tache_nom</option>\n";
	}
?>

					</select>
				</td>
			</tr>
<?php
}
?>
			<tr>
				<td class="cellright" valign="top"><?php echo TXT_MOD_PRESTATIONS_REMARQUES; ?></td>
				<td class="cellleft"><textarea name="pre_remarques" cols="50" rows="5"><?php echo $pre_remarques; ?></textarea></td>
			</tr>
			<tr>
				<td colspan="2" class="cellcenter">
					<input type="submit" class="bouton" value="<?php echo TXT_MOD_PRESTATIONS_MODIFIER; ?>">
				</td>
			</tr>
			<tr>
				<td colspan="2" class="tablecomment"><?php echo TXT_MOD_PRESTATIONS_CHAMPS_OBLIGATOIRES; ?></td>
			</tr>
		</table>
	</form>
	
	<br />

</div>

<?php
require_once ('include/footer.php');
?>