<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

function day_month_year($ymd) {
    /************* file: date_functions.php ************
     convert a given string date ($ymd) 
	 from format yyyy-mm-dd  into
     a string date ($dmy) format  dd-mm-yyy
     parameters: $ymd, $year, $month, $day, $dmy
    ********************************/
    $year = substr( $ymd,0,4);
    $month = substr( $ymd,5,2);
    switch ($month) {
    	   case "01":
    	   $month = "janvier";
    	   break;
    	   case "02":
    	   $month = "f&eacute;vrier";
    	   break;
    	   case "03":
    	   $month = "mars";
    	   break;
    	   case "04":
    	   $month = "avril";
    	   break;
    	   case "05":
    	   $month = "mai";
    	   break;
    	   case "06":
    	   $month = "juin";
    	   break;
    	   case "07":
    	   $month = "juillet";
    	   break;
    	   case "08":
    	   $month = "ao&ucirc;t";
    	   break;
    	   case "09":
    	   $month = "septembre";
    	   break;
    	   case "10":
    	   $month = "octobre";
    	   break;
    	   case "11":
    	   $month = "novembre";
    	   break;
    	   case "12":
    	   $month = "d&eacute;cembre";
    	   break;
    	   }
    $day = substr($ymd,8,2);
    $dmy = $day.'&nbsp;'.$month.'&nbsp;'.$year;
    	if ($dmy == '00&nbsp;00&nbsp;0000'){
    	//echo 'dmy = '.$dmy;
		$showdmy = '-';
    	}
    else {
    $showdmy = $dmy;}
    return $showdmy;
    }

function FormateDate ($ymdhms)
{
	$dh = "le ".day_month_year(substr($ymdhms,0,10));
	$dh .= " &agrave; ".substr($ymdhms,11,2)."h".substr($ymdhms,14,2);
	return $dh;
}
    
function diffdate ($date,$mode)
{
	$year = substr($date,0,4);
	$month = substr($date,5,2);
	$day = substr($date,8,2);
	// echo $day." ".$month." ".$year;
	// exit;
	$diff = facteur(date('j'),date('n'),date('Y')) - facteur($day,$month,$year);

	switch ($mode)
	{
		case 'd':
			break;
		case 'y':
			$diff = floor($diff/365);
			break;
	}
	return $diff; 
}

function facteur($jour,$mois,$annee)
{
	$b=365*$annee;
	$c=31*($mois-1);
	if (($mois==1) || ($mois==2))
	{
		$d= 0;
		$e = intval(($annee -1)/4);
		$h = intval(0.75*(intval(($annee-1)/100)+1));
	}
	else
	{
		$d= intval(0.4*$mois+2.3);
		$e = intval($annee/4);
		$h = intval(0.75*(intval($annee/100)+1));
	}
	$result = $jour + $b+ $c - $d +$e -$h;
	return $result;
}

function annee ($date)
{
	return substr($date,0,4);
}

function Mois ($date)
{
	return substr($date,5,2);
}

function Jour ($date)
{
	return substr($date,8,2);
}

function NomDuMois ($mois)
{
	switch ($mois)
	{
		case 1:
			$month = "janvier";
			break;
		case 2:
			$month = "f&eacute;vrier";
			break;
		case 3:
			$month = "mars";
			break;
		case 4:
			$month = "avril";
			break;
		case 5:
			$month = "mai";
			break;
		case 6:
			$month = "juin";
			break;
		case 7:
			$month = "juillet";
			break;
		case 8:
			$month = "ao&ucirc;t";
			break;
		case 9:
			$month = "septembre";
			break;
		case 10:
			$month = "octobre";
			break;
		case 11:
			$month = "novembre";
			break;
		case 12:
			$month = "d&eacute;cembre";
			break;
  }
  return $month;
}

function NomDuMoisCourt ($mois)
{
	switch ($mois)
	{
		case 1:
			$month = "jan";
			break;
		case 2:
			$month = "f&eacute;v";
			break;
		case 3:
			$month = "mar";
			break;
		case 4:
			$month = "avr";
			break;
		case 5:
			$month = "mai";
			break;
		case 6:
			$month = "juin";
			break;
		case 7:
			$month = "juil";
			break;
		case 8:
			$month = "ao&ucirc;t";
			break;
		case 9:
			$month = "sep";
			break;
		case 10:
			$month = "oct";
			break;
		case 11:
			$month = "nov";
			break;
		case 12:
			$month = "d&eacute;c";
			break;
  }
  return $month;
}

function heures ($hrs)
{
	if (($hrs*10) % 10 > 0)
	{
		$heure = floor($hrs)."h30";
	}
	else
	{
		$heure = floor($hrs)."h00";
	}
	return $heure;
}

function JourPrecedent ($date)
{
	$tm = gmmktime(12,0,0,Mois($date),Jour($date),annee($date));
	$tm = strtotime("-1 day",$tm);
	return date('Y-m-d',$tm);
}

function JourSuivant ($date)
{
	$tm = gmmktime(12,0,0,Mois($date),Jour($date),annee($date));
	$tm = strtotime("+1 day",$tm);
	return date('Y-m-d',$tm);
}

function MoisMoinsTrois ($mois,$annee)
{
	$mois -= 3;
	if ($mois <= 0)
	{
		$mois += 12;
		$annee -= 1;
	}
	return NomDuMois($mois)." ".$annee;
}

?>
