<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

?>

<div class="content">

<?php
require_once ("include/checklevel.php");
?>

	<h2><?php echo TXT_CSV_LISTE_FICHIERS_CSV; ?></h2>
	
	<p>
		<a href="delete.php?mode=csv&id=all"><?php echo TXT_CSV_SUPPRIMER_TOUS_LES_FICHIERS; ?></a><br />
	</p>
	
	<table border="0" width="100%" align="center" cellpadding="3" cellspacing="0">
		<tr>
			<th><?php echo TXT_CSV_DATE; ?></th>
			<th><?php echo TXT_CSV_TYPE; ?></th>
			<th><?php echo TXT_CSV_FICHIER; ?></th>
			<th><?php echo TXT_CSV_ACTIONS; ?></th>
		</tr>
		
<?php
$count = 0;
$req = Requete ("SELECT * FROM fichiers_csv ORDER BY csv_date DESC;",$conn);

if (NombreLignes($req) == 0)
{
	echo "<tr>\n";
	echo "<td colspan=\"4\"><center>".TXT_CSV_AUCUN_FICHIER."</center></td>\n";
	echo "</tr>\n";
}
else
{
	while ($rs = ObjetSuivant($req))
	{
		$count += 1;
		if ($count % 2 > 0)
		{
			$class = "data1";
		}
		else
		{
			$class = "data2";
		}
		echo "<tr class=\"".$class."\">\n";
		echo "<td>".day_month_year($rs->csv_date)."</td>\n";
		switch ($rs->csv_type)
		{
			case 1:
				echo "<td>".TXT_CSV_PREST_PAR_UTILISATEUR."</td>\n";
				break;
			case 2:
				echo "<td>".TXT_CSV_PREST_PAR_PROJET."</td>\n";
				break;
			case 3:
				echo "<td>".TXT_CSV_TOUTES_LES_PRESTATIONS."</td>\n";
				break;
			case 4:
				echo "<td>".TXT_CSV_STATISTIQUES."</td>\n";
				break;
		}
		echo "<td><a href=\"download_file.php?fichier=".$rs->csv_fichier."\">".$rs->csv_fichier."</a></td>\n";
		echo "<td class=\"cellright\">";
		echo "<a href=\"delete.php?mode=csv&id=".$rs->csv_id."\"><img src=\"images/b_drop.gif\" border=\"0\" alt=\"".TXT_CSV_SUPPRIMER."\" title=\"".TXT_CSV_SUPPRIMER."\"></a>";
		echo "</td>\n";
		echo "</tr>\n";
	}
}

?>

	</table>
	
	<br />

</div>

<?php
require_once ('include/footer.php');
?>