<?php
##############################################################
# FILENAME  : report_tournament.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define ( IN_PHPBB, true );
$phpbb_root_path	= './';

include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( !$userdata[ 'session_logged_in' ] )
{
	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ltfin' ] );
}

if ( !empty ( $http_vars[ 'submit' ] ) )
{
	$brack	= $tournament->data[ 'tournament_brackets' ];
	$dbllw	= $tournament->data[ 'tournament_dbllw' ];
	$dblww	= $tournament->data[ 'tournament_dblww' ];
	$type	= $tournament->data[ 'tournament_type' ];

	if ( $http_vars[ 'type' ] == 1 )
	{
		$exemption	= explode ( '|', $tournament->data[ 'tournament_exemptions' ] );
		foreach ( $exemption AS $exempt )
		{
			$split	= explode ( ':', $exempt );
			foreach ( $split AS $data )
			{
				if ( $split[ 0 ] == $clan->data[ 'clan_id' ] && $split[ 1 ] == 'w' )
				{
					message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
				}
			}
		}

		$looser_check	= explode ( '|', $tournament->data[ 'tournament_clans2' ] );
		if ( count ( $looser_check ) > 0 )
		{
			foreach ( $looser_check AS $sclan )
			{
				$looser_check_2	= explode ( ':', $sclan );
				foreach  ( $looser_check_2 AS $clan_2 )
				{
					if ( $clan_2[ 0 ] == $clan->data[ 'clan_id' ] )
					{
						message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
					}
				}
			}
		}

		$stage_1	= explode ( '|', $tournament->data[ 'tournament_clans' ] );
		$total		= count ( $stage_1 );
		$new		= array ( );

		for ( $i = 0; $i < $total; $i++ )
		{
			if ( in_multi_array ( $stage_1[ $i ], $new ) || in_multi_array ( $stage_1[ $i + 1 ], $new ) )
			{
				continue;
			}
			else
			{
				$new[ ]	= array ( $stage_1[ $i ], $stage_1[ $i + 1 ] );
			}
		}


		$i	= 0;
		foreach ( $new AS $clans )
		{
			foreach ( $clans AS $check )
			{
				$stage_2	= explode ( ':', $check );
				foreach ( $stage_2 AS $find )
				{
					if ( $stage_2[ 0 ] == $clan->data[ 'clan_id' ] )
					{
						$pos	= $i;
						if ( substr ( $clans[ 0 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 0 ], $clans[ 1 ] );
						}
						else if ( substr ( $clans[ 1 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 1 ], $clans[ 0 ] );
						}
						else
						{
							continue;
						}
					}
				}
			}

			$i++;
		}

		$history	= array_reverse ( multi_unique ( $info ) );
		$has_match	= true;

		foreach ( $history AS $past )
		{
			if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) == 0 )
			{
				$has_match	= false;
			}
			else if ( strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) == 0 )
			{
				$has_match	= false;
			}
			else
			{
				if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) > 0 || strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) > 0 )
				{
					$match_up	= $past;
					$has_match	= true;

					break;
				}
				else
				{
					continue;
				}
			}
		}

		if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) )
		{
			foreach ( $match_up AS $bigger )
			{
				$explode	= explode ( ':', $bigger );
				$explode_2	= explode ( '_', $explode[ 1 ] );
				$last[ ]	= $explode_2[ 0 ] . '-' . $explode_2[ 1 ];
			}

			$match_up	= ( str_replace ( '-', '', $last[ 0 ] ) > str_replace ( '-', '', $last[ 1 ] ) ) ? array ( $clan->data[ 'clan_id' ] . '|' . str_replace ( '-', '_', $last[ 0 ] ), $new[ $pos + 1 ][ 0 ] ) : array ( $clan->data[ 'clan_id' ] . ':' . str_replace ( '-', '_', $last[ 1 ] ), $new[ $pos + 1 ][ 0 ] );
		}

		if ( $has_match == false )
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_17bvz' ] );
		}

		$clan		= ( strstr ( $match_up[ 0 ], $clan->data[ 'clan_id' ] . ':' ) ) ? $match_up[ 0 ] : $match_up[ 1 ];
		$clan_2		= ( $clan == $match_up[ 0 ] ) ? $match_up[ 1 ] : $match_up[ 0 ];

		$explode	= explode ( ':', $clan );
		$explode	= explode ( '_', $explode[ 1 ] );
		$explode_2	= explode ( ':', $clan_2 );

		$temp_rows	= $tournament->data[ 'tournament_brackets' ];
		while ( $temp_rows > 1 )
		{
			$row_count++;

			if ( $row_count > 1 )
			{
				$temp_rows	= ( $temp_rows / 2 );
			}

			$rows	= $row_count;
		}

		if ( $rows == $explode[ 0 ] + 1 && $type == 2 )
		{
			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_dblw = "' . $clan->data[ 'clan_id' ] . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
			$db->sql_query ( $sql );

			if ( strlen ( $tournament->data[ 'tournament_clans2' ] ) > 0 )
			{
				foreach ( explode ( '|', $tournament->data[ 'tournament_clans2' ] ) AS $clans )
				{
					foreach ( explode ( ':', $clans ) AS $clans_2 )
					{
						$stage_3	= explode ( '_', $clans_2 );
						foreach ( explode ( '_', $clans_2 ) AS $clans_3 )
						{
							if ( $clans_3[ 0 ] == '1' )
							{
								$new_tfdmn[ ]	= $stage_3[ 1 ];
							}
						}
					}
				}
			}

			$position2	= explode ( ':', $clan_2 );
			$split2		= explode ( '_', $position2[ 1 ] );

			$new_tfdmn_2	= @array_reverse ( multi_unique ( $new_tfdmn ) );
			$new_fkj		= $tournament->data[ 'tournament_clans2' ] . '|' . $position2[ 0 ] . ':1' . '_' . ( $new_tfdmn_2[ 0 ] + 1 );

			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_clans2 = "' . $new_fkj . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
			$db->sql_query ( $sql );
		}
		else if ( $type == 2 )
		{
			if ( strlen ( $tournament->data[ 'tournament_clans2' ] ) > 0 )
			{
				foreach ( explode ( '|', $tournament->data[ 'tournament_clans2' ] ) AS $clans )
				{
					foreach ( explode ( ':', $clans ) AS $clans_2 )
					{
						$stage_3	= explode ( '_', $clans_2 );
						foreach ( explode ( '_', $clans_2 ) AS $clans_3 )
						{
							if ( $clans_3[ 0 ] == 1 )
							{
								$new_tfdmn[ ]	= $stage_3[ 1 ];
							}
						}
					}
				}
			}

			$position2	= explode ( ':', $clan_2 );
			$split2		= explode ( '_', $position2[ 1 ] );

			$new_tfdmn_2	= @array_reverse ( multi_unique ( $new_tfdmn ) );
			$new_fkj		= $tournament->data[ 'tournament_clans2' ] . '|' . $position2[ 0 ] . ':1' . '_' . ( $new_tfdmn_2[ 0 ] + 1 );

			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_clans2 = "' . $new_fkj . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
			$db->sql_query ( $sql );
		}

		$new_clans	= $tournament->data[ 'tournament_clans' ] . '|' . $clan->data[ 'clan_Id' ] . ':' . ( $explode[ 0 ] + 1 ) . '_' . ( round ( $explode[ 1 ] / 2 ) );
		$exemptions	= $tournament->data[ 'tournament_exemptions' ] . '|' . $explode_2[ 0 ] . ':w';

		$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_clans = "' . $new_clans . '", tournament_exemptions = "' . $exemptions . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_hsufw' ] );
	}
	else if ( $http_vars[ 'type' ] == 2 )
	{
		$exemption	= explode ( '|', $tournament->data[ 'tournament_exemptions' ] );
		foreach ( $exemption AS $exempt )
		{
			$split	= explode ( ':', $exempt );
			foreach ( $split AS $data )
			{
				if ( $split[ 0 ] == $clan->data[ 'clan_Id' ] && $split[ 1 ] == 'lw' )
				{
					message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
				}
			}
		}

		$looser_check	= explode ( '|', $tournament->data[ 'tournament_clans2' ] );
		if ( count ( $looser_check ) > 0 )
		{
			foreach ( $looser_check AS $sclan )
			{
				$looser_check_2	= explode ( ':', $sclan );
				foreach  ( $looser_check_2 AS $clan_2 )
				{
					if ( $clan_2[ 0 ] != $clan->data[ 'clan_Id' ] )
					{
						$cheating	= true;
					}
					else
					{
						$cheating	= false;
						break ( 2 );
					}
				}
			}
		}

		if ( $cheating == true )
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
		}

		$stage_1	= explode ( '|', $tournament->data[ 'tournament_clans2' ] );
		$total		= count ( $stage_1 );
		$new		= array ( );

		if ( count ( $stage_1 ) < $tournament->data[ 'tournament_brackets' ] - 1 )
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_p3' ] );
		}

		for ( $i = 0; $i < $total; $i++ )
		{
			if ( in_multi_array ( $stage_1[ $i ], $new ) || in_multi_array ( $stage_1[ $i + 1 ], $new ) )
			{
				continue;
			}
			else
			{
				$new[ ]	= array ( $stage_1[ $i ], $stage_1[ $i + 1 ] );
			}
		}

		$i	= 0;
		foreach ( $new AS $clans )
		{
			foreach ( $clans AS $check )
			{
				$stage_2	= explode ( ':', $check );
				foreach ( $stage_2 AS $find )
				{
					if ( $stage_2[ 0 ] == $clan->data[ 'clan_id' ] )
					{
						$pos	= $i;
						if ( substr ( $clans[ 0 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 0 ], $clans[ 1 ] );
						}
						else if ( substr ( $clans[ 1 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 1 ], $clans[ 0 ] );
						}
						else
						{
							continue;
						}
					}
				}
			}

			$i++;
		}

		$history	= @array_reverse ( multi_unique ( $info ) );
		$has_match	= true;

		foreach ( $history AS $past )
		{
			if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) == 0 )
			{
				$has_match	= false;
			}
			else if ( strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) == 0 )
			{
				$has_match	= false;
			}
			else
			{
				if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) > 0 || strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) > 0 )
				{
					$match_up	= $past;
					$has_match	= true;

					break;
				}
				else
				{
					continue;
				}
			}
		}

		if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) )
		{
			foreach ( $match_up AS $bigger )
			{
				$explode	= explode ( ':', $bigger );
				$explode_2	= explode ( '_', $explode[ 1 ] );
				$last[ ]	= $explode_2[ 0 ] . '-' . $explode_2[ 1 ];
			}

			$match_up	= ( str_replace ( '-', '', $last[ 0 ] ) > str_replace ( '-', '', $last[ 1 ] ) ) ? array ( $clan->data[ 'clan_id' ] . '|' . str_replace ( '-', '_', $last[ 0 ] ), $new[ $pos + 1 ][ 0 ] ) : array ( $clan->data[ 'clan_id' ] . ':' . str_replace ( '-', '_', $last[ 1 ] ), $new[ $pos + 1 ][ 0 ] );
		}

		if ( $has_match == false )
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_17bvz' ] );
		}

		$clan		= ( strstr ( $match_up[ 0 ], $clan->data[ 'clan_id' ] . ':' ) ) ? $match_up[ 0 ] : $match_up[ 1 ];
		$clan_2		= ( $clan == $match_up[ 0 ] ) ? $match_up[ 1 ] : $match_up[ 0 ];

		$explode	= explode ( ':', $clan );
		$explode	= explode ( '_', $explode[ 1 ] );
		$explode_2	= explode ( ':', $clan_2 );

		$temp_rows	= $tournament->data[ 'tournament_brackets' ] - 1;
		while ( $temp_rows > 1 )
		{
			$row_count++;

			if ( $row_count > 1 )
			{
				$temp_rows	= ( $temp_rows / 2 );
			}

			$rows	= $row_count;
		}

		if ( $rows == $explode[ 0 ] + 1 )
		{
			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_dbllw = "' . $clan->data[ 'clan_id' ] . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
			$db->sql_query ( $sql );
		}

		$new_clans	= $tournament->data[ 'tournament_clans2' ] . '|' . $clan->data[ 'clan_id' ] . ':' . ( $explode[ 0 ] + 1 ) . '_' . ( round ( $explode[ 1 ] / 2 ) );
		$exemptions	= $tournament->data[ 'tournament_exemptions' ] . '|' . $explode_2[ 0 ] . ':lw';

		$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_clans2 = "' . $new_clans . '", tournament_exemptions = "' . $exemptions . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_hsufw' ] );
	}
	else if ( $http_vars[ 'type' ] == 3 )
	{
		$exemption	= explode ( '|', $tournament->data[ 'tournament_exemptions' ] );
		foreach ( $exemption AS $exempt )
		{
			$split	= explode ( ':', $exempt );
			foreach ( $split AS $data )
			{
				if ( $split[ 0 ] == $clan->data[ 'clan_id' ] && $split[ 1 ] == 'l' )
				{
					message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
				}
			}
		}

		$looser_check	= explode ( '|', $tournament->data[ 'tournament_clans2' ] );
		if ( count ( $looser_check ) > 0 )
		{
			foreach ( $looser_check AS $sclan )
			{
				$looser_check_2	= explode ( ':', $sclan );
				foreach  ( $looser_check_2 AS $clan_2 )
				{
					if ( $clan_2[ 0 ] == $clan_id )
					{
						message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
					}
				}
			}
		}

		$stage_1	= explode ( '|', $tournament->data[ 'tournament_clans' ] );
		$total		= count ( $stage_1 );
		$new		= array ( );

		for ( $i = 0; $i < $total; $i++ )
		{
			if ( in_multi_array ( $stage_1[ $i ], $new ) || in_multi_array ( $stage_1[ $i + 1 ], $new ) )
			{
				continue;
			}
			else
			{
				$new[ ]	= array ( $stage_1[ $i ], $stage_1[ $i + 1 ] );
			}
		}

		$i	= 0;
		foreach ( $new AS $clans )
		{
			foreach ( $clans AS $check )
			{
				$stage_2	= explode ( ':', $check );
				foreach ( $stage_2 AS $find )
				{
					if ( $stage_2[ 0 ] == $clan->data[ 'clan_id' ] )
					{
						$pos	= $i;
						if ( substr ( $clans[ 0 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 0 ], $clans[ 1 ] );
						}
						else if ( substr ( $clans[ 1 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 1 ], $clans[ 0 ] );
						}
						else
						{
							continue;
						}
					}
				}
			}

			$i++;
		}

		$history	= array_reverse ( multi_unique ( $info ) );
		$has_match	= true;

		foreach ( $history AS $past )
		{
			if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) == 0 )
			{
				$has_match	= false;
			}
			else if ( strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) == 0 )
			{
				$has_match	= false;
			}
			else
			{
				if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) > 0 || strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) > 0 )
				{
					$match_up	= $past;
					$has_match	= true;

					break;
				}
				else
				{
					continue;
				}
			}
		}

		if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) )
		{
			foreach ( $match_up AS $bigger )
			{
				$explode	= explode ( ':', $bigger );
				$explode_2	= explode ( '_', $explode[ 1 ] );
				$last[ ]	= $explode_2[ 0 ] . '-' . $explode_2[ 1 ];
			}

			$match_up	= ( str_replace ( '-', '', $last[ 0 ] ) > str_replace ( '-', '', $last[ 1 ] ) ) ? array ( $clan->data[ 'clan_id' ] . '|' . str_replace ( '-', '_', $last[ 0 ] ), $new[ $pos + 1 ][ 0 ] ) : array ( $clan->data[ 'clan_id' ] . ':' . str_replace ( '-', '_', $last[ 1 ] ), $new[ $pos + 1 ][ 0 ] );
		}

		if ( $has_match == false )
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_17bvz' ] );
		}

		$clan		= ( strstr ( $match_up[ 0 ], $clan->data[ 'clan_id' ] . ':' ) ) ? $match_up[ 0 ] : $match_up[ 1 ];
		$clan_2		= ( $clan == $match_up[ 0 ] ) ? $match_up[ 1 ] : $match_up[ 0 ];

		$explode	= explode ( ':', $clan );
		$explode	= explode ( '_', $explode[ 1 ] );
		$explode_2	= explode ( ':', $clan_2 );

		$exemptions	= $tournament->data[ 'tournament_exemptions' ] . '|' . $clan->data[ 'clan_id' ] . ':w' . '|' . $explode_2[ 0 ] . ':' . 'l';

		$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_exemptions = "' . $exemptions . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_hswfw' ] );
	}
	else if ( $http_vars[ 'type' ] == 4 )
	{
		$exemption	= explode ( '|', $tournament->data[ 'tournament_exemptions' ] );
		foreach ( $exemption AS $exempt )
		{
			$split	= explode ( ':', $exempt );
			foreach ( $split AS $data )
			{
				if ( $split[ 0 ] == $clan->data[ 'clan_id' ] && $split[ 1 ] == 'll' )
				{
					message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
				}
			}
		}

		$looser_check	= explode ( '|', $tournament->data[ 'tournament_clans2' ] );
		if ( count ( $looser_check ) > 0 )
		{
			foreach ( $looser_check AS $sclan )
			{
				$looser_check_2	= explode ( ':', $sclan );
				foreach  ( $looser_check_2 AS $clan_2 )
				{
					if ( $clan_2[ 0 ] != $clan->data[ 'clan_id' ] )
					{
						$cheating	= true;
					}
					else
					{
						$cheating	= false;
					}
				}
			}
		}

		if ( $cheating == true )
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_war' ] );
		}

		$stage_1	= explode ( '|', $tournament->data[ 'tournament_clans2' ] );
		$total		= count ( $stage_1 );
		$new		= array ( );

		for ( $i = 0; $i < $total; $i++ )
		{
			if ( in_multi_array ( $stage_1[ $i ], $new ) || in_multi_array ( $stage_1[ $i + 1 ], $new ) )
			{
				continue;
			}
			else
			{
				$new[ ]	= array ( $stage_1[ $i ], $stage_1[ $i + 1 ] );
			}
		}


		$i	= 0;
		foreach ( $new AS $clans )
		{
			foreach ( $clans AS $check )
			{
				$stage_2	= explode ( ':', $check );
				foreach ( $stage_2 AS $find )
				{
					if ( $stage_2[ 0 ] == $clan->data[ 'clan_id' ] )
					{
						$pos	= $i;
						if ( substr ( $clans[ 0 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 0 ], $clans[ 1 ] );
						}
						else if ( substr ( $clans[ 1 ], 0, strlen ( $clan->data[ 'clan_id' ] ) ) == $clan->data[ 'clan_id' ] )
						{
							$info[ ]	= array ( $clans[ 1 ], $clans[ 0 ] );
						}
						else
						{
							continue;
						}
					}
				}
			}

			$i++;
		}

		$history	= @array_reverse ( multi_unique ( $info ) );
		$has_match	= true;

		foreach ( $history AS $past )
		{
			if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) == 0 )
			{
				$has_match	= false;
			}
			else if ( strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) == 0 )
			{
				$has_match	= false;
			}
			else
			{
				if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 1 ] ) > 0 || strstr ( $past[ 1 ], $clan->data[ 'clan_id' ] . ':' ) && strlen ( $past[ 0 ] ) > 0 )
				{
					$match_up	= $past;
					$has_match	= true;

					break;
				}
				else
				{
					continue;
				}
			}
		}

		if ( strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) && strstr ( $past[ 0 ], $clan->data[ 'clan_id' ] . ':' ) )
		{
			foreach ( $match_up AS $bigger )
			{
				$explode	= explode ( ':', $bigger );
				$explode_2	= explode ( '_', $explode[ 1 ] );
				$last[ ]	= $explode_2[ 0 ] . '-' . $explode_2[ 1 ];
			}

			$match_up	= ( str_replace ( '-', '', $last[ 0 ] ) > str_replace ( '-', '', $last[ 1 ] ) ) ? array ( $clan->data[ 'clan_id' ] . '|' . str_replace ( '-', '_', $last[ 0 ] ), $new[ $pos + 1 ][ 0 ] ) : array ( $clan->data[ 'clan_id' ] . ':' . str_replace ( '-', '_', $last[ 1 ] ), $new[ $pos + 1 ][ 0 ] );
		}

		if ( $has_match == false )
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_17bvz' ] );
		}

		$clan		= ( strstr ( $match_up[ 0 ], $clan->data[ 'clan_id' ] . ':' ) ) ? $match_up[ 0 ] : $match_up[ 1 ];
		$clan_2		= ( $clan == $match_up[ 0 ] ) ? $match_up[ 1 ] : $match_up[ 0 ];

		$explode	= explode ( ':', $clan );
		$explode	= explode ( '_', $explode[ 1 ] );
		$explode_2	= explode ( ':', $clan_2 );

		$exemptions	= $tournament->data[ 'tournament_exemptions' ] . '|' . $clan->data[ 'clan_id' ] . ':lw' . '|' . $explode_2[ 0 ] . ':' . 'll';

		$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_exemptions = "' . $exemptions . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_hswfw' ] );
	}
	else if ( $http_var[ 'type' ] == 5 )
	{
		if ( $tournament->data[ 'tournament_dblw' ] == $clan->data[ 'clan_id' ] || $tournament->data[ 'tournament_dbll' ] == $clan->data[ 'clan_id' ] )
		{
			$winner	= ( $tournament->data[ 'tournament_dblw' ] == $clan_id ) ? $tournament->data[ 'tournament_dblw' ] : $tournament->data[ 'tournament_dbll' ];
			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_winner = "' . $winner . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
			$db->sql_query ( $sql );

			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_12az' ] );
		}
		else
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_1q2az' ] );
		}
	}
	else if ( $http_var[ 'type' ] == 6 )
	{
		if ( $tournament->data[ 'tournament_dblw' ] == $clan->data[ 'clan_id' ] || $tournament->data[ 'tournament_dbll' ] == $clan->data )
		{
			$winner	= ( $tournament->data[ 'tournament_dblw' ] == $clan->data[ 'clan_id' ] ) ? $tournament->data[ 'tournament_dbll' ] : $tournament->data[ 'tournament_dblw' ];
			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_winner = "' . $winner . '" WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
			$db->sql_query ( $sql );

			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_12asz' ] );
		}
		else
		{
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_1q2az' ] );
		}
	}
	else
	{
		$stage_1	= explode ( '|', $tournament->data[ 'tournament_clans2' ] );
		$total		= count ( $stage_1 );
		$new		= array ( );

		for ( $i = 0; $i < $total; $i++ )
		{
			if ( in_multi_array ( $stage_1[ $i ], $new ) || in_multi_array ( $stage_1[ $i + 1 ], $new ) )
			{
				continue;
			}
			else
			{
				$new[ ]	= array ( $stage_1[ $i ], $stage_1[ $i + 1 ] );
			}
		}

		$new	= array_reverse ( $new );
		foreach ( $new AS $clans )
		{
			foreach ( $clans AS $check )
			{
				$stage_2	= explode ( ':', $check );
				foreach ( $stage_2 AS $find )
				{
					if ( $stage_2[ 0 ] == $clan->data[ 'clan_id' ] && empty ( $clans[ 0 ] ) || empty ( $clans[ 1 ] ) )
					{
						$found	= true;
						break (3);
					}
					else if ( $stage_2[ 1 ] == $clan->data[ 'clan_id' ] && empty ( $clans[ 0 ] ) || empty ( $clans[ 1 ] ) )
					{
						$found	= true;
						break (3);
					}
					else
					{
						$found	= false;
					}
				}
			}
		}

		if ( $found == true )
		{
			$pass_on	= $tournament->pass_on ( 'tournament_clans2' );

			if ( $pass_on == true )
			{
				message_die ( GENERAL_MESSAGE, $lang[ 'rivals_55dc' ] );
			}
		}
		else
		{
			$stage_1	= explode ( '|', $tournament->data[ 'tournament_clans' ] );
			$total		= count ( $stage_1 );
			$new		= array ( );

			for ( $i = 0; $i < $total; $i++ )
			{
				if ( in_multi_array ( $stage_1[ $i ], $new ) || in_multi_array ( $stage_1[ $i + 1 ], $new ) )
				{
					continue;
				}
				else
				{
					$new[ ]	= array ( $stage_1[ $i ], $stage_1[ $i + 1 ] );
				}
			}

			$new	= array_reverse ( $new );
			foreach ( $new AS $clans )
			{
				foreach ( $clans AS $check )
				{
					$stage_2	= explode ( ':', $check );
					foreach ( $stage_2 AS $find )
					{
						if ( $stage_2[ 0 ] == $clan->data[ 'clan_id' ] )
						{
							if ( empty ( $clans[ 1 ] ) )
							{
								$found	= true;
								break ( 3 );
							}
							else
							{
								$found	= false;
							}
						}
						else if ( $stage_2[ 1 ] == $clan->data[ 'clan_id' ] && empty ( $stage_2[ 0 ] ) )
						{
							$found	= true;
							break ( 3 );
						}
						else
						{
							$found	= false;
						}
					}
				}
			}

			if ( $found == true )
			{
				$pass_on	= $tournament->pass_on ( 'tournament_clans' );

				if ( $pass_on == true )
				{
					message_die ( GENERAL_MESSAGE, $lang[ 'rivals_55dc' ] );
				}
			}
			else
			{
				message_die ( GENERAL_MESSAGE, $lang[ 'rivals_28wQ' ] );
			}
		}
	}
}

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx );

?>
