<?php
##############################################################
# FILENAME  : mcp.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation;
# either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
# Boston, MA  02110-1301  USA
##############################################################
define ( IN_PHPBB, true );
$phpbb_root_path	= './';

include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( !$userdata[ 'session_logged_in' ] )
{
	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ltfin' ] );
}

$sql	= 'SELECT * FROM ' . CLANS_TABLE . ' WHERE clan_members != "" AND clan_owner != ' . $userdata[ 'user_id' ];
$result	= $db->sql_query ( $sql );

if ( $db->sql_numrows ( $result ) > 0 )
{
	for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
	{
		$row	= $db->sql_fetchrow ( $result );

		$explode	= explode ( '|', $row[ 'clan_members' ] );
		if ( in_array ( $userdata[ 'user_id' ], $explode ) )
		{
			$template->assign_block_vars ( 'block_clans', array (
				'S_CLANNAME' => $row[ 'clan_name' ],
				'U_LEAVE' => append_sid ( 'jl_clan.php?clan_id=' . $row[ 'clan_id' ] ),
				'L_LEAVE' => $lang[ 'rivals_swize' ] )
			);

			$sql_2		= 'SELECT * FROM ' . CHALLENGES_TABLE . ' WHERE (challenger = "' . $row[ 'clan_id' ] . '" OR challengee = "' . $row[ 'clan_id' ] . '") ORDER BY challenge_id DESC';
			$result_2	= $db->sql_query ( $sql_2 );

			if ( $db->sql_numrows ( $result_2 ) > 0 )
			{
				for ( $x = 0; $x < $db->sql_numrows ( $result_2 ); $x++ )
				{
					$row_2	= $db->sql_fetchrow ( $result_2 );
			
					if ( $row_2[ 'challenge_status' ] == '1' )
					{
						$status	= $lang[ 'rivals_uiiii' ];
					}
					else if ( $row_2[ 'challenge_status' ] == '2' )
					{
						$status	= $lang[ 'rivals_oiiii' ];
					}
					else
					{
						$status	= $lang[ 'rivals_tiiii' ];
					}

					$templates->assign_block_vars ( 'block_clans.block_matches', array (
						'S_STATUS' => $status,
						'S_DATE' => ( !empty ( $row_2[ 'challenge_time' ] ) ) ? $row_2[ 'challenge_time' ] : 'N/A',
						'S_CHALLENGER' => ( $row_2[ 'challenger' ] == $clan->data ( 'clan_id', $http_vars[ 'clan_id' ] ) ) ? '<b>' . $clan->data ( 'clan_name', $row_2[ 'challenger' ] ) . '</b>' : $clan->data ( 'clan_name', $row_2[ 'challenger' ] ),
						'S_CHALLENGEE' => ( $row_2[ 'challengee' ] == $clan->data ( 'clan_id', $http_vars[ 'clan_id' ] ) ) ? '<b>' . $clan->data ( 'clan_name', $row_2[ 'challengee' ] ) . '</b>' : $clan->data ( 'clan_name', $row_2[ 'challengee' ] ),
						'S_ROWCOLOR' => ( $i++ % 2 ) ? 'row1' : 'row2',
						'S_WINNER' => ( $row_2[ 'challenge_status' ] == '3' ) ? $clan->data ( 'clan_name', $row_2[ 'challenge_winner' ] ) : 'N/A' )
					);
				}
			}
			else
			{
				$template->assign_block_vars ( 'block_clans.block_nomatches', array (
					'L_NOMATCHES' => $lang[ 'rivals_aussi' ] )
				);
			}
		}
	}
}
else
{
	$template->assign_block_vars ( 'no_clans', array (
		'L_NOCLANS' => $lang[ 'niiacul' ] )
	);
}

$template->assign_vars ( array (
	'L_RIVALS_MCP' => $lang[ 'mcps' ] )
);

$template->set_filenames ( array (
	'body' => 'rivals/mcp.tpl' )
);

$template->pparse ( 'body' );

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx );
?>