/*
 * testpdslstring.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdslstring.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdslstring testpdslstring.c -lpdsdatafunc

# Test command
./testpdslstring 
\endverbatim
 * <br>
 * 
 */

    
#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>

int main(int argc, char* argv[])
{
    PdsListString *Lall=NULL;
    
    // Creating a new list string.
    Lall=pds_list_string_new();
    if(Lall==NULL) return EXIT_FAILURE;
    
    
    // Adding values to the cell string.
    pds_list_string_push(&Lall,"1st text string.");
    pds_list_string_push(&Lall,"2nd text string.");
    pds_list_string_push(&Lall,"3dh text string.");
    pds_list_string_push(&Lall,"4th text string.");
    
    
    // Printing values of the cell string.
    printf("\nPdsListString *Lall=\n");
    pds_list_string_all_printf(Lall);
    
    
    return EXIT_SUCCESS;
}

