/*
 * testpdsargsfunc.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsargsfunc.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2016
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */


#include <config.h>
#include <stdlib.h>
#include <pds/pdsdatafunc.h>

int main(int argc, char* argv[])
{
	int i=0;
	long long l=0;
	float f=0;
	double d=0;
	char *s=NULL; 

	if(pds_exist_param(argc,argv,"--int"))	printf("Existe --int\n");

	pds_get_int_param(argc,argv,"--int",&i);
	pds_get_llint_param(argc,argv,"--long",&l);
	pds_get_float_param(argc,argv,"--float",&f);
	pds_get_double_param(argc,argv,"--double",&d);
	pds_get_chars_param(argc,argv,"--chars",&s);

	printf("   --int:\t%d\tsizeof:\t%lu\n",i,(long unsigned int)sizeof(i));
	printf("  --long:\t%lld\tsizeof:\t%lu\n",l,(long unsigned int)sizeof(l));
	printf(" --float:\t%e\tsizeof:\t%lu\n",f,(long unsigned int)sizeof(f));
	printf("--double:\t%e\tsizeof:\t%lu\n",d,(long unsigned int)sizeof(d));
	printf(" --chars:\t%s\tsizeof:\t%lu\n",s,(long unsigned int)sizeof(s));
	
	return EXIT_SUCCESS;
}

