/*
 * File modified by Fernndo Pujaico Rivera from fnmatch.h the Regents of the 
 * University of California.
 */

/*-
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)fnmatch.h	8.1 (Berkeley) 6/2/93
 *
 * From FreeBSD fnmatch.h 1.7
 * $Id: fnmatch.h,v 1.4 2001/10/04 02:46:21 jdp Exp $
 */

#ifndef	_PDS_FNMATCH_H_
#define	_PDS_FNMATCH_H_

#ifndef FNM_NOMATCH
#define	FNM_NOMATCH	1	/* Match failed. */
#endif

#ifndef FNM_NOESCAPE
#define	FNM_NOESCAPE	0x01	/* Disable backslash escaping. */
#endif

#ifndef FNM_PATHNAME
#define	FNM_PATHNAME	0x02	/* Slash must be matched by slash. */
#endif

#ifndef FNM_PERIOD
#define	FNM_PERIOD	0x04	/* Period must be matched by period. */
#endif

#ifndef FNM_LEADING_DIR
#define	FNM_LEADING_DIR	0x08	/* Ignore /<tail> after Imatch. */
#endif

#ifndef FNM_CASEFOLD
#define	FNM_CASEFOLD	0x10	/* Case insensitive search. */
#endif

#ifndef FNM_PREFIX_DIRS
#define FNM_PREFIX_DIRS	0x20	/* Directory prefixes of pattern match too. */
#endif
/* Make this compile successfully with "gcc -traditional" */
#ifndef __STDC__
#define const	/* empty */
#endif

/** \defgroup PdsFnMatchGroup Funciones del módulo PdsFnMatch.
 *
 *  <br>
 *  Función.
 * @{
 */

/** \fn int	 pds_fnmatch(const char *pattern, const char *string, int flags)
 *  \brief función similar a fnmatch(), creada para tener compatibilidad en MinGw
 *  (code From FreeBSD fnmatch.h 1.7).
 *
 * The fnmatch() function checks whether the string argument matches the pattern 
 * argument, which is a shell wildcard pattern.
 * The flags argument modifies the behavior; it is the bitwise OR of zero or more 
 * of the following flags:
 * 
 * FNM_NOESCAPE
 * If this flag is set, treat backslash as an ordinary character, instead of an 
 * escape character.
 *
 * FNM_PATHNAME
 * If  this flag is set, match a slash in string only with a slash in pattern 
 * and not by an asterisk (*) or a question mark (?) metacharacter, nor by a 
 * bracket expression ([]) containing a slash. 
 *
 * FNM_PERIOD
 * If this flag is set, a leading period in string has to be matched exactly by 
 * a period in pattern.  A period is considered to be leading if  it  is
 * the first character in string, or if both FNM_PATHNAME is set and the period 
 * immediately follows a slash.
 *
 * FNM_LEADING_DIR
 * If  this  flag (a GNU extension) is set, the pattern is considered to be 
 * matched if it matches an initial segment of string which is followed by a
 * slash.  This flag is mainly for the internal use of glibc and is implemented 
 * only in certain cases.
 *
 * FNM_CASEFOLD
 * If this flag (a GNU extension) is set, the pattern is matched case-insensitively.
 *
 *  \param[in] pattern Patron de busqueda.
 *  \param[in] string Cadena en analisis.
 *  \param[in] flags Flags de busqueda.
 *  \return Zero if string matches pattern, FNM_NOMATCH if there is no match or 
 *  another nonzero value if there is an error.
 *  \ingroup PdsFnMatchGroup
 */
int	 pds_fnmatch(const char *pattern, const char *string, int flags);

/**
 * @}
 */

#endif /* !_PDS_FNMATCH_H_ */
