/*
 * testprog5.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testprog5.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2016
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */


// ./testprog5 /text/file.c
#include <config.h>
#include <stdlib.h>
#include <pds/pdsdatafunc.h>

int main(int argc, char* argv[])
{

    char *cadena=NULL;
    char CAD[]="/path_to_file/filename.c";
    char *DATA=NULL;
    PdsCellString *CELL=NULL;
    
    if(argc==1)
        cadena=CAD;
    else
        cadena=argv[1];

    printf("\n");
    printf("--------------------------- Names --------------------------\n");
    printf("filepath :\t%s\n",cadena);
    printf("basename :\t%s\n",pds_get_basename(cadena));
    printf("extension:\t%s\n",pds_get_filename_extension(cadena));
    printf("filename :\t%s\n",pds_get_filename(cadena));
    printf("dirname  :\t%s\n",pds_get_dirname(cadena));
    printf("other_ext:\t%s\n",pds_get_filepath_with_extension(cadena,"mp4"));
    printf("temporal :\t%s\n",pds_get_temporal_filepath(cadena,NULL));
    printf("-------------------------------------------------------------\n");

    DATA=pds_get_filedata_string("/media/fernando/FER8G-FAT32/13796666_1820767234818515_150427356_n.metadata","genre=");
    if(DATA!=NULL)  printf("\n%s\n",DATA);
    printf("\n");

    CELL=pds_get_filedata_cell_string("/media/fernando/FER8G-FAT32/13796666_1820767234818515_150427356_n.metadata","genre=",",");
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    printf("\n");


    return EXIT_SUCCESS;
}

