/*
 * testprog4.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprog4.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2016
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsdatafunc.h>

char *func(const char *data)
{
    char *rep=NULL;

    rep=(char*)calloc(32,1);
    sprintf(rep,"MARIANO");
    return rep;
}

int main(int argc, char* argv[])
{
    char *cad=NULL;
    int val;
    const char string[] = "Samba,Gafieira,,Puladinho,Gafieira";
    const char delimiters[] = ",;:";
    PdsCellString *token=NULL;

    cad=pds_sprintf("Data:%d - %s - %f - %p", 33,"text",1.68,&val);
    
    printf("\n");
    printf("<<%s>>\n",cad);

    printf("\n");
    printf("     string: %s\n",string);
    printf(" delimiters: %s\n",delimiters);
    printf("\n");

    printf("\n<<<< Tokens >>>>\n");
    token=pds_strsep(string,delimiters);    
    if(token!=NULL)
    pds_cell_string_all_printf(token);

    printf("\n<<<< Tokens >>>>\n");
    pds_cell_string_findci_and_remove(token,"GAFIEIRA");
    pds_cell_string_all_printf(token);

    printf("\n<<<< pds_strcicmp() >>>>\n");
    if(pds_strcicmp("Hola","HOLA")==0)  printf("They are equals.\n");
    else                                printf("They are differents.\n");



    printf("\n\n");
    printf("====================================================================\n");
    pds_file_pattern_replacement("Makefile.am.out","Makefile.am","testprog1","exemplo1");
    char *cad0=pds_string_new_from_file("Makefile.am.out");
    printf("%s\n",cad0);
    printf("====================================================================\n");


    printf("\n");
    char str[]="hola <b>Fernando</b> como está <b>trucomanx</b> y <b></b>";
    char *str_ptr=str;
    char *rawdata=NULL;
    do{
        printf("\ninicio :%s\n",str_ptr);        

        rawdata=pds_string_new_rawdata_after_match(str_ptr,"<b>","</b>",&str_ptr);

        if(rawdata!=NULL) printf("rawdata:%s\n",rawdata);
        free(rawdata);

    }while(str_ptr!=NULL);
    printf("\n");

    pds_file_content_replacement("datapat2.dat","datapat.dat","<b>","</b>",func);

    return EXIT_SUCCESS;
}

