#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

import ConfigParser

config = ConfigParser.ConfigParser()
config.add_section('common')
config.set('common', 'pidfile', '/var/run/openclone/webservice.pid')
config.add_section('database')
config.set('database', 'db_url', 'mysql://root:@localhost/openclone')
#config.add_section('network')
#config.set('network', 'full_duplex', True)
config.add_section('logging')
config.set('logging', 'logfile', '/var/log/openclone/webservice.log')
config.set('logging', 'loglevel', 'info')
config.set('logging', 'keep_days', '0')
config.add_section('storage')
config.set('storage', 'data_path', '/data')
config.add_section('webservice')
config.set('webservice', 'listen_addr', '')
config.set('webservice', 'listen_port', '18080')
