<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

    include('functions/hostlist_func.php');
    try
    {
        if(isset($_POST['selectGroup']))
        {
            getGroups($_POST['selectGroup']);
        }
        else
        {
            getGroups('running');
        }
    }
    catch(Exception $getGroupsException)
    {
        echo 'Error: Unable to get groups!<br/>';
        echo 'System Error: '.$getGroupsException->getMessage().'<br/><br/>';
    }

    echo '<br/>';
    if(isset($_POST['editSubmit']))
    {
        if(isset($_POST['addTaskToHost']))
        {
            try
            {
                addTaskToHost($_POST['selectTask'], $_POST['selectedHost']);
            }
            catch(Exception $addTaskToHostException)
            {
                echo 'Error: Unable to add tasks to hosts!<br/>';
                echo 'System Error: '.$addTaskToHostException->getMessage().'<br/><br/>';
            }
        }
        if(isset($_POST['changeIP']))
        {
            try
            {
                editIPAddress($_POST['selectedHost'], $_POST['startIP'], $_POST['IPOffset']);
            }
            catch(Exception $editIPAddressException)
            {
                echo 'Error: Unable to edit IP addresses!<br/>';
                echo 'System Error: '.$editIPAddressException->getMessage().'<br/><br/>';
            }
        }
        if(isset($_POST['changeHostname']))
        {
            try
            {
                editHostname($_POST['selectedHost'], $_POST['hostnamePrefix'], $_POST['hostnameStartingNumber'], $_POST['hostnameNumberOffset']);
            }
            catch(Exception $editHostnameException)
            {
                echo 'Error: Unable to edit hostnames!<br/>';
                echo 'System Error: '.$editHostnameException->getMessage().'<br/><br/>';
            }
        }
        if(isset($_POST['addHostToGroup']))
        {
            try
            {
                addHostToGroup($_POST['selectedHost'], $_POST['selectAddGroup']);
            }
            catch(Exception $addHostToGroupException)
            {
                echo 'Error: Unable to add hosts to group!<br/>';
                echo 'System Error: '.$addHostToGroupException->getMessage().'<br/><br/>';
            }
        }
    }

    if(isset($_POST['selectGroup']))
    {
        try
        {
            if(isset($_POST['markHosts']))
            {
                getHosts($_POST['selectGroup'], 1);
            }
            else
            {
                getHosts($_POST['selectGroup'], 0);
            }
        }
        catch(Exception $getHostsException)
        {
            echo 'Error: Unable to get hosts!<br/>';
            echo 'System Error: '.$getHostsException->getMessage().'<br/><br/>';
        }
    }

    else
    {
        try
        {
            getHosts('running', 0);
        }
        catch(Exception $getHostsException)
        {
            echo 'Error: Unable to get hosts!<br/>';
            echo 'System Error: '.$getHostsException->getMessage().'<br/><br/>';
        }
    }
?>


