<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/
?>
<form method="post">
    <label>Group name: <input type="text" name="groupName"/></label>
    <input type="submit" name="addGroupSubmit" value="Add Group" />
</form>
<br/>

<?php
    include('functions/grouplist_func.php');

    if(isset($_POST['addGroupSubmit']))
    {
        try
        {
            addGroup($_POST['groupName']);
        }
        catch(Exception $addGroupException)
        {
            echo 'Error: Unable to add group!<br/>';
            echo 'System Error: '.$addGroupException->getMessage().'<br/><br/>';
        }
    }

    else if(isset($_POST['groupOperationSubmit']) && isset($_POST['selectedGroup']))
    {
        try
        {
            if($_POST['selectGroupOperation'] == 'delete')
            {
                deleteGroup($_POST['selectedGroup']);
            }
            else if($_POST['selectGroupOperation'] == 'edit')
            {
                echo '<meta http-equiv="Refresh" content="0; URL=index.php?menu=advanced&site=groupedit&groupid='.$_POST['selectedGroup'].'">';
            }
        }
        catch(Exception $performOperationOnGroupException)
        {
            echo 'Error: Unable to perform operation on group!<br/>';
            echo 'System Error: '.$performOperationOnGroupException->getMessage().'<br/><br/>';
        }
    }

    try
    {
        getGroups();
    }
    catch(Exception $getGroupsException)
    {
        echo 'Error: Unable to get groups!<br/>';
        echo 'System Error: '.$getGroupsException->getMessage().'<br/><br/>';
    }
?>
