<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function addTask($taskDescription)
{
    $task = new Task();
    $task->description = $taskDescription;
    $maxTaskSequence = Doctrine_Query::create()->select('MAX(Task.sequence) as max_sequence')->from('Task')->execute();
    $maxTaskSeq = $maxTaskSequence[0]->max_sequence;
    $task->sequence = $maxTaskSeq + 1;
    $task->save();
}

function deleteTask($taskId)
{
    $task = Doctrine_Query::create()->from('Task')->where('id='.$taskId)->execute();
    $operations = Doctrine_Query::create()->from('Operation')->where('task_id='.$task[0]->id)->execute();
    foreach($operations as $operation)
    {
        if($operation->type == 'image')
        {
            $op = Doctrine_Query::create()->from('OperationImage')->where('id='.$operation->id)->execute();
            $op->delete();
        }
        else if($operation->type == 'partition')
        {
            $op = Doctrine_Query::create()->from('OperationPartition')->where('id='.$operation->id)->execute();
            $op->delete();
        }
        else if($operation->type == 'shutdown')
        {
            $op = Doctrine_Query::create()->from('OperationShutdown')->where('id='.$operation->id)->execute();
            $op->delete();
        }
        $operation->delete();
    }
    
    $hostTasks = Doctrine_Query::create()->from('HostTask')->where('task_id='.$task[0]->id)->execute();
    foreach($hostTasks as $hostTask)
    {
        $hostTask->delete();
    }

    $task[0]->delete();
}

function getTasks()
{
    echo '<form method="POST" action="">';

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Task ID</u></b></td>';
    echo '<td><b><u>Task Description</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $tasks = Doctrine_Query::create()->from('Task')->execute();
    foreach($tasks as $task)
    {
        echo '<tr>';
        echo '<td><input type="radio" name="selectedTask" value="'.$task->id.'"/></td>';
        echo '<td>'.$task->id.'</td>';
        echo '<td>'.$task->description.'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';

    echo '<select name="selectTaskOperation" size="1">';
    echo '<option value="delete">Delete</option>';
    echo '<option value="edit">Edit</option>';
    echo '<input type="submit" name="taskOperationSubmit" value="OK" />';
    echo '</form>'; 
}
?>
