<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function deleteOperation($operationIds)
{
    for($i=0; $i<count($operationIds); $i++)
    {
        $operation = Doctrine_Query::create()->from('Operation')->where('id='.$operationIds[$i])->execute();
        if($operation[0]->type == 'image')
        {
            $op = Doctrine_Query::create()->from('OperationImage')->where('id='.$operation[0]->id)->execute();
            $op->delete();
        }
        else if($operation[0]->type == 'partition')
        {
            $op = Doctrine_Query::create()->from('OperationPartition')->where('id='.$operation[0]->id)->execute();
            $op->delete();
        }
        else if($operation[0]->type == 'shutdown')
        {
            $op = Doctrine_Query::create()->from('OperationShutdown')->where('id='.$operation[0]->id)->execute();
            $op->delete();
        }
        $operation[0]->delete();
    }
}

function addOperationShutdown($taskId, $shutdownMode)
{
    $maxOperationSequence = Doctrine_Query::create()->select('MAX(Operation.sequence) as max_sequence')->from('Operation')->where('Operation.task_id='.$taskId)->execute();
    $maxOperationSeq = $maxOperationSequence[0]->max_sequence;

    $operationShutdown = new OperationShutdown();
    $operationShutdown->task_id = $taskId;
    $operationShutdown->sequence = $maxOperationSeq + 1;
    $operationShutdown->type = 'shutdown';
    if($shutdownMode == 'poweroff')
    {
        $operationShutdown->mode = 'poweroff';
    }
    else if($shutdownMode == 'reboot')
    {
        $operationShutdown->mode = 'reboot';
    }
    $operationShutdown->save();

}

function getOperations($taskId)
{
    echo '<form method="POST" action="">';

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td>Operation ID</td>';
    echo '<td>Operation Type</td>';
    echo '<td>Operation Options</td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $operations = Doctrine_Query::create()->from('Operation')->where('task_id='.$taskId)->execute();
    foreach($operations as $operation)
    {
        echo '<tr>';
        echo '<td><input type="checkbox" name="selectedOperations[]" value="'.$operation->id.'"/></td>';
        echo '<td>'.$operation->id.'</td>';
        echo '<td>'.$operation->type.'</td>';
        if($operation->type == 'image')
        {
            $operationImage = Doctrine_Query::create()->from('OperationImage')->where('id='.$operation->id)->execute();
            echo '<td>Mode: '.$operationImage[0]->mode.'</td>';
        }
        else if($operation->type == 'shutdown')
        {
            $operationShutdown = Doctrine_Query::create()->from('OperationShutdown')->where('id='.$operation->id)->execute();
            echo '<td>Mode: '.$operationShutdown[0]->mode.'</td>';
        }
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';
    echo '<input type="submit" name="operationDeleteSubmit" value="Delete Operation(s)" />';
    echo '</form>';
}
?>
