<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function getTasks()
{
    $tasks = Doctrine_Query::create()->from('HostTask')->where('status="running" or status="finished"')->orderBy('status desc')->execute();

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td><b><u>Description</u></b></td>';
    echo '<td><b><u>Hostname</u></b></td>';
    echo '<td><b><u>Percentage</u></b></td>';
    echo '<td><b><u>Speed</u></b></td>';
    echo '<td><b><u>Status</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    foreach($tasks as $task)
    {
        $taskDescription = Doctrine_Query::create()->from('Task')->where('id='.$task->task_id)->execute();
        $host = Doctrine_Query::create()->from('Host')->where('id='.$task->host_id)->execute();
        echo '<tr>';
        echo '<td>'.$taskDescription[0]->description.'</td>';
        echo '<td>'.$host[0]->hostname.'</td>';
        echo '<td>'.$task->percentage.'</td>';
        echo '<td>'.$task->speed.'</td>';
        echo '<td>'.$task->status.'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';
}
?>
