#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

import array
import fcntl
import struct

# See linux/ioctl.h
_IOC_NRBITS    = 8
_IOC_TYPEBITS  = 8
_IOC_SIZEBITS  = 14
_IOC_DIRBITS   = 2
#_IOC_NRMASK    = ((1 << _IOC_NRBITS)-1)
#_IOC_TYPEMASK  = ((1 << _IOC_TYPEBITS)-1)
#_IOC_SIZEMASK  = ((1 << _IOC_SIZEBITS)-1)
#_IOC_DIRMASK   = ((1 << _IOC_DIRBITS)-1)
_IOC_NRSHIFT   = 0
_IOC_TYPESHIFT = (_IOC_NRSHIFT+_IOC_NRBITS)
_IOC_SIZESHIFT = (_IOC_TYPESHIFT+_IOC_TYPEBITS)
_IOC_DIRSHIFT  = (_IOC_SIZESHIFT+_IOC_SIZEBITS)
_IOC_NONE      = 0
_IOC_WRITE     = 1
_IOC_READ      = 2

def _IOC(dir,type,nr,size):
    return (((dir)  << _IOC_DIRSHIFT) |
            ((type) << _IOC_TYPESHIFT) |
            ((nr)   << _IOC_NRSHIFT) |
            ((size) << _IOC_SIZESHIFT))

def _IO(type,nr):
    return _IOC(_IOC_NONE, type, nr, 0)

def _IOR(type,nr,size):
    return _IOC(_IOC_READ, type, nr, size)

def _IOW(type,nr,size):
    return _IOC(_IOC_WRITE, type, nr, size)

def _IOWR(type,nr,size):
    return _IOC(_IOC_READ|_IOC_WRITE, type, nr, size)


def getInt(fd, opt):
    buff = array.array('i', [0])
    fcntl.ioctl(fd, opt, buff)
    return buff[0]

def getULong(fd, opt):
    buff = array.array('L', [0])
    fcntl.ioctl(fd, opt, buff)
    return buff[0]

def getULongLong(fd, opt):
    buff = array.array('L', [0, 0])
    fcntl.ioctl(fd, opt, buff)
    return (buff[1] << 32) + buff[0]

def getStruct(fd, opt, format):
    buff = struct.Struct(format)
    return buff.unpack(fcntl.ioctl(fd, opt, ' ' * buff.size))
