#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

from distutils.core import setup
import os.path
import sys

sys.path.insert(0, 'src')
from openclone.common import version
sys.path.remove('src')

setup(name='openclone-engine',
      version=version.version_str,
      description='OpenClone Engine',
      author='David Gnedt',
      author_email='david.gnedt@platinumzone24.at',
      url='http://www.nongnu.org/openclone/',
      package_dir={'': 'src'},
      packages=['openclone', 'openclone.common', 'openclone.common.transfer',
                'openclone.engine', 'openclone.engine.compression',
                'openclone.engine.imaging', 'openclone.engine.misc',
                'openclone.engine.partition', 'openclone.engine.sysinfo',
                'openclone.engine.webservice'],
      scripts=['scripts/openclone-engine'],
      )
