#
# $Id: database.py 86 2009-05-02 19:02:20Z lxp $
#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

from sqlalchemy import create_engine, sql
from sqlalchemy.exceptions import InvalidRequestError
from sqlalchemy.orm import relation, scoped_session, sessionmaker

from tablemapping import *

engine = None

def initialize(url):
    global engine
    engine = create_engine(url)

class Database:
    def __init__(self):
        Session = scoped_session(sessionmaker(transactional=True,
                                              autoflush=False, bind=engine))
        #Base.metadata.create_all(engine)
        self.session = Session()
    
    def now(self):
        return sql.func.now()
    
    newHost = Host
    newCPUDevice = CPUDevice
    newRAMDevice = RAMDevice
    newHardDiskDevice = HardDiskDevice
    newMBRPartitiontable = MBRPartitiontable
    newMBRPartition = MBRPartition
    newImageOperation = ImageOperation
    newPartitionOperation = PartitionOperation
    newShutdownOperation = ShutdownOperation
    
    def queryHostByMac(self, m):
        try:
            host = self.session.query(Host).filter_by(mac=m).one()
        except InvalidRequestError:
            host = None
        
        return host
    
    def queryHostTask(self, host_id, task_id):
        hosttask = self.session.query(HostTask).get((host_id, task_id))
        return hosttask
    
    def save(self, obj):
        self.session.save(obj)
    
    def delete(self, obj):
        self.session.delete(obj)
    
    def commit(self):
        self.session.commit()
    
    #def output(self):
    #    print [i.id for i in self.session.query(Host).all()]
    
    def close(self):
        self.session.close()
