<?php
/*
 $Id: hostlist_func.php 86 2009-05-02 19:02:20Z lxp $

 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function getHosts($selectedGroup, $markHosts)
{
   if($selectedGroup == 'all')
    {
        $hosts = Doctrine_Query::create()->from('Host')->execute();
    }
    else if($selectedGroup == 'running')
    {
        $hosts = Doctrine_Query::create()->from('Host')->where('running=1')->execute();
    }
    else if($selectedGroup == 'no_group')
    {
        $hosts = Doctrine_Query::create()->from('Host')->where('group_id IS NULL')->execute();
    }
    else
    {
        $hosts = Doctrine_Query::create()->from('Host')->where('group_id='.$selectedGroup)->execute();
    }

    echo '<br/>';
    echo '<b>Shown Hosts: </b>'.count($hosts);
    echo '<br/>';
    echo '<br/>';

    echo '<form method="POST" action="">';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Boot ID</u></b></td>';
    echo '<td><b><u>Hostname</u></b></td>';
    echo '<td><b><u>IP Address</u></b></td>';
    echo '<td><b><u>MAC Address</u></b></td>';
    echo '<td><b><u>Group</u></b></td>';
    echo '<td><b><u>Boottime</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    foreach($hosts as $host)
    {
        echo '<tr>';
        if($markHosts == 1)
        {
            echo '<td><input type="checkbox" name="selectedHost[]" value="'.$host->id.'" checked/></td>';
        }
        else
        {
            echo '<td><input type="checkbox" name="selectedHost[]" value="'.$host->id.'"/></td>';
        }
        echo '<td><a href="?menu=advanced&site=hostdetails&hostId='.$host->id.'">Details</a></td>';
        echo '<td>'.$host->id.'</td>';
        echo '<td>'.$host->hostname.'</td>';
        echo '<td>'.$host->ip.'</td>';
        echo '<td>'.$host->mac.'</td>';
        
        if(empty($host->group_id))
        {
            echo '<td>None</td>';
        }
        else
        {
            $group = Doctrine_Query::create()->from('Group')->where('id='.$host->group_id)->execute();
            echo '<td>'.$group[0]->name.'</td>';
        }
        echo '<td>'.$host->last_boot_time.'</td>';
        echo '</tr>';
        //echo '<tr>';
        //echo '<td>&nbsp;</td>';
        //echo '<td colspan="5" align="left"><b>Tasks:</b></td>';
        //echo '</tr>';

        //$tasksForHost = Doctrine_Query::create()->select('Task.description')->from('Task, HostTask')->where('HostTask.host_id='.$host->id)->addwhere('HostTask.task_id=Task.id')->execute();

        //foreach($tasksForHost as $taskForHost)
        //{
        //    echo '<tr>';
        //    echo '<td>&nbsp;</td>';
        //    echo '<td colspan="5" align="left">'.$taskForHost->description.'</td>';
        //    echo '</tr>';
        //}
        //echo '<tr>';
        //echo '<td colspan="6">&nbsp;</td>';
        //echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';
    echo '<br/>';
    echo '<br/>';
    echo '<table>';
    $tasks = Doctrine_Query::create()->from('Task')->execute();
    echo '<tr>';
    echo '<td colspan="2">';
    echo '<label><input type="checkbox" name="addTaskToHost" value="addTaskToHost" /><b>Add task to host</b></label>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td colspan="2">';
    echo '<select name="selectTask" size="1">';
    foreach($tasks as $task)
    {
        echo '<option value="'.$task->id.'">'.$task->description.'</option>';
    }
    echo '</select>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td colspan="2">&nbsp;</td>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td colspan="2">';
    echo '<label><input type ="checkbox" name="changeIP" value="changeIP" /><b>Change IP Address</b></label>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>';
    echo 'Start IP Address:';
    echo '</td>';
    echo '<td>';
    echo '<input type="text" name="startIP" />';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>';
    echo 'IP Offset:';
    echo '</td>';
    echo '<td>';
    echo '<input type="text" name="IPOffset" />';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td colspan="2">&nbsp;</td>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td colspan="2">';
    echo '<label><input type ="checkbox" name="changeHostname" value="changeHostname" /><b>Change Hostname</b></label>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>';
    echo 'Prefix:';
    echo '</td>';
    echo '<td>';
    echo '<input type="text" name="hostnamePrefix" />';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>';
    echo 'Starting number:';
    echo '</td>';
    echo '<td>';
    echo '<input type="text" name="hostnameStartingNumber" />';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>';
    echo 'Number offset:';
    echo '</td>';
    echo '<td>';
    echo '<input type="text" name="hostnameNumberOffset" />';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td colspan="2">&nbsp;</td>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td colspan="2">';
    echo '<label><input type ="checkbox" name="addHostToGroup" value="addHostToGroup" /><b>Add Host to Group</b></label>';
    echo '</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>';
    echo 'Group:';
    echo '</td>';
    echo '<td>';
    echo '<select name="selectAddGroup" size="1">';
    $groups = Doctrine_Query::create()->from('Group')->execute();
    foreach($groups as $group)
    {
        echo '<option value="'.$group->id.'">'.$group->name.'</option>';
    }
    echo '</select>';
    echo '</td>';
    echo '</tr>';
    echo '</table>';

    echo '<br/>';
    echo '<br/>';
    echo '<input type="hidden" name="selectGroup" value="'.$selectedGroup.'" />';
    echo '<input type="submit" name="editSubmit" value="OK" />';
    echo '</form>';

}

function getGroups($activeGroup)
{
    $groups = Doctrine_Query::create()->from('Group')->execute();

    echo '<form method="post">';
    echo '<select name="selectGroup" size="1">';
    if($activeGroup == 'all')
    {
        echo '<option value="all" selected>All Hosts</option>';
    }
    else
    {
        echo '<option value="all">All Hosts</option>';
    }
    if($activeGroup == 'running')
    {
        echo '<option value="running" selected>Running Hosts</option>';
    }
    else
    {
        echo '<option value="running">Running Hosts</option>';
    }
    if($activeGroup == 'no_group')
    {
        echo '<option value="no_group" selected>No Group</option>';
    }
    else
    {
        echo '<option value="no_group">No Group</option>';
    }

    echo '<optgroup label="Groups">';
    foreach($groups as $group)
    {
        if($activeGroup == $group->id)
        {
            echo '<option value="'.$group->id.'" selected>'.$group->name.'</option>';
        }
        else
        {
            echo '<option value="'.$group->id.'">'.$group->name.'</option>';
        }
    }
    echo '</optgroup>';

    echo '</select>';
    echo '<label><input type="checkbox" name="markHosts" />mark Hosts </label>';
    echo '<input type="submit" name="chooseClientsSubmit" value="Show" />';
    echo '</form>';    
}

function addTaskToHost($taskId, $hostIds)
{
    for($i=0; $i<count($hostIds); $i++)
    {
        $hostTask = new HostTask();
        $hostTask->host_id = $hostIds[$i];
        $hostTask->task_id = $taskId;
        $hostTask->status = 'running';
        $hostTask->save();
    }
}

function editIPAddress($hostIds, $startIP, $IPOffset)
{
    $startIPOctetts = explode('.',$startIP);
    $startIPFirstOctetts = $startIPOctetts[0].'.'.$startIPOctetts[1].'.'.$startIPOctetts[2];
    $startIPLastOctett = $startIPOctetts[3];
    for($i=0; $i<count($hostIds); $i++)
    {
        $host = Doctrine_Query::create()->from('Host')->where('id='.$hostIds[$i])->execute();
        $host[0]->ip = $startIPFirstOctetts.'.'.($startIPLastOctett+$IPOffset*$i);
        $host[0]->save();
    }
}

function editHostname($hostIds, $hostnamePrefix, $hostnameStartingNumber, $hostnameNumberOffset)
{
    for($i=0; $i<count($hostIds); $i++)
    {
        $host = Doctrine_Query::create()->from('Host')->where('id='.$hostIds[$i])->execute();
        $host[0]->hostname = $hostnamePrefix.sprintf('%03d', $hostnameStartingNumber+$hostnameNumberOffset*$i);
        $host[0]->save();
    }
}

function addHostToGroup($hostIds, $groupId)
{
    for($i=0; $i<count($hostIds); $i++)
    {
        $host = Doctrine_Query::create()->from('Host')->where('id='.$hostIds[$i])->execute();
        $host[0]->group_id = $groupId;
        $host[0]->save();
    }
}
?>
