#
# $Id: setup.py 86 2009-05-02 19:02:20Z lxp $
#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

from distutils.core import setup
import os.path
import sys

# Update svn revision if available
if os.path.exists('.svn/entries'):
    f = open('.svn/entries', 'r')
    lines = f.readlines()
    f.close()
    rev = int(lines[3])
    
    lines = []
    f = open('src/openclone/common/version.py', 'r+')
    for line in f:
        if line.startswith('svnrev = '):
            lines.append('svnrev = %d\n' % rev)
        
        else:
            lines.append(line)
    
    f.seek(0)
    f.truncate()
    f.writelines(lines)
    f.close()

sys.path.insert(0, 'src')
from openclone.common import version
sys.path.remove('src')

setup(name='openclone-engine',
      version=version.version_str,
      description='OpenClone Engine',
      author='David Gnedt',
      author_email='david.gnedt@platinumzone24.at',
      url='http://www.nongnu.org/openclone/',
      package_dir={'': 'src'},
      packages=['openclone', 'openclone.common', 'openclone.common.transfer',
                'openclone.engine', 'openclone.engine.compression',
                'openclone.engine.imaging', 'openclone.engine.misc',
                'openclone.engine.partition', 'openclone.engine.sysinfo',
                'openclone.engine.webservice'],
      scripts=['scripts/openclone-engine'],
      )
