/* This file is part of Patchage.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LASHCONTROLLER_H
#define LASHCONTROLLER_H

#include <ladcca/ladcca.h>
#include <pthread.h>

class Patchage;

class LashController {
public:
	LashController(Patchage* app, int argc, char** argv);
	~LashController();

	void process_events();
	
	//void start_thread();
	//void stop_thread();

private:
	Patchage*     m_app;
	cca_client_t* m_client;
	
	void handle_event(cca_event_t* conf);
	void handle_config(cca_config_t* conf);
	
	//bool      m_lash_thread_exit_flag;
	//pthread_t m_lash_thread;
	
	//static void* lash_loop(void* me) { return ((LashController*)me)->m_lash_loop(); }
	//void*        m_lash_loop();
};


#endif // LASHCONTROLLER_H
