/* This file is part of Patchage.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "LashController.h"
#include "config.h"
#include <iostream>
#include <string>
#include "Patchage.h"

using std::cerr; using std::cout; using std::endl;
using std::string;


LashController::LashController(Patchage* app, int argc, char** argv)
: m_app(app),
  m_client(NULL)
  //m_lash_thread_exit_flag(false)
{
	m_client = cca_init(cca_extract_args(&argc, &argv), PACKAGE_NAME,
		/*CCA_Config_Data_Set|*/CCA_Config_File, CCA_PROTOCOL(2, 0));
	if (m_client == NULL) {
		cerr << "Failed to connect to LASH.  Session management will not occur." << endl;
	}	
}


LashController::~LashController()
{
	if (m_client != NULL) {
		cca_event_t* quit_event = cca_event_new_with_type(CCA_Quit);
		cca_send_event(m_client, quit_event);
	}
}

/*
void
LashController::start_thread()
{
	pthread_create(&m_lash_thread, NULL, &LashController::lash_loop, this);

	cca_event_t* name_event = cca_event_new_with_type(CCA_Client_Name);
	cca_event_set_string(name_event, "Patchage");
	cca_send_event(m_client, name_event);
}


void
LashController::stop_thread()
{
	m_lash_thread_exit_flag = true;
}


void*
LashController::m_lash_loop()
{
	cca_event_t*  ev = NULL;
	cca_config_t* conf = NULL;
	
	while (!m_lash_thread_exit_flag) {
		
		// Process events
		while ((ev = cca_get_event(m_client)) != NULL) {
			handle_event(ev);
			cca_event_destroy(ev);	
		}

		// Process configs
		while ((conf = cca_get_config(m_client)) != NULL) {
			handle_config(conf);
			cca_config_destroy(conf);	
		}

		sleep(1);
	}

	return NULL;
}
*/

void
LashController::process_events()
{
	cca_event_t*  ev = NULL;
	cca_config_t* conf = NULL;

	// Process events
	while ((ev = cca_get_event(m_client)) != NULL) {
		handle_event(ev);
		cca_event_destroy(ev);	
	}

	// Process configs
	while ((conf = cca_get_config(m_client)) != NULL) {
		handle_config(conf);
		cca_config_destroy(conf);	
	}
}


void
LashController::handle_event(cca_event_t* ev)
{
	CCA_Event_Type type = cca_event_get_type(ev);
	const char*    c_str = cca_event_get_string(ev);
	string         str   = (c_str == NULL) ? "" : c_str;
	
	cout << "********** LASH Event.  Type = " << type << ", string = " << str << "**********" << endl;
	
	if (type == CCA_Save_File) {
		cout << "****** LASH Save File - " << str << endl;
		m_app->state_manager()->save(str.append("/locations"));
		cca_send_event(m_client, cca_event_new_with_type(CCA_Save_File));
	} else if (type == CCA_Restore_File) {
		cout << "****** LASH Restore File - " << str << endl;
		m_app->state_manager()->load(str.append("/locations"));
		m_app->update_state();
		cca_send_event(m_client, cca_event_new_with_type(CCA_Restore_File));
	} else if (type == CCA_Save_Data_Set) {
		cout << "****** LASH Save Data Set - " << endl;
		
		// Tell LASH we're done
		cca_send_event(m_client, cca_event_new_with_type(CCA_Save_Data_Set));
	} else if (type == CCA_Quit) {
		//stop_thread();
		m_client = NULL;
		m_app->quit();
	}
}


void
LashController::handle_config(cca_config_t* conf)
{
	const char*    key      = NULL;
	const void*    val      = NULL;
	size_t         val_size = 0;

	cout << "********** LASH Config.  Key = " << key << "**********" << endl;

	key      = cca_config_get_key(conf);
	val      = cca_config_get_value(conf);
	val_size = cca_config_get_value_size(conf);
}



