/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "Connection.h"
#include <libgnomecanvasmm.h>

namespace PatchBay {
	

Connection::Connection(Gnome::Canvas::Group* parent_group, Port* source_port, Port* dest_port)
: Gnome::Canvas::Line(*parent_group),
  m_source_port(source_port),
  m_dest_port(dest_port)
{
	m_color = m_source_port->color() + 0x44444400;
	property_width_units() = 1.0;
	property_fill_color_rgba() = m_color;
	property_cap_style() = (Gdk::CapStyle)GDK_CAP_ROUND;

	property_arrow_shape_a() = 7.5;
	property_arrow_shape_b() = 10.0;
	property_arrow_shape_c() = 2.5;

	property_smooth() = true;

	update_location();	
}


/** Updates the connection's location to match it's source/dest ports.
 *
 * This is used when modules are dragged, to keep the connections attached
 * to their ports.
 */
void
Connection::update_location()
{
	Gnome::Canvas::Points points;
	points.push_back(m_source_port->connection_coords());
	points.push_back(m_dest_port->connection_coords());

	property_points() = points;
}


/** Removes the reference to this connection contained in the ports.
 *
 * Must be called before destroying a connection.
 */
void Connection::disconnect()
{
	m_source_port->remove_connection(this);
	m_dest_port->remove_connection(this);
	m_source_port = NULL;
	m_dest_port = NULL;
}


void Connection::hilite(bool b)
{
	if (b)
		property_fill_color_rgba() = 0xFF0000FF;
	else
		property_fill_color_rgba() = m_color;
}


} // namespace PatchBay

