/************************************************************************
 *                                                                      *
 * Open File Manager - ncurses file manager for GNU/Linux               *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski                *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/
 
#include "misc.h" 
#include "iface.h"
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

WINDOW *tmp_win;
char *buffer;
int cp_newname;


int dlgMessageBox(int but,char* buf,char *name,char *message)
{
    WINDOW *mw;  
    
	/* a char */
	
	int key; 

	/* window width */

    int len,tlen;

	/* window height */
	
    int wh;	

	/* number of buttons */
	
    unsigned char bc;

	/* tablicuje(?) the buttons from but */
	
    unsigned char bar[3];

	/* marked button */
	
    int  bsel;

	/* temporary/helping buffor */
	
    char *tbuf;
    bool isbuf;

	/* first visible char */
	
    char *bfirstchar;
    
	/* buf position, buf size, actual buf size */
	
	unsigned int bpos,bsize,bvsize;

	/* button position, number of columns used by the buttons */
	
    unsigned int but_pos, but_cols;

    bc=0;

	/* you could check if the terminal isn't smaller */
	
    wh=7;
    bsel=0;
    but_pos=0;
    but_cols=0;
    tbuf=NULL;
    if (but==0) return 0;
    if (buf!=NULL) {
	if ((tbuf=(char *)xmalloc(PATH_MAX))==NULL) return 0; 
	memset(tbuf,0,PATH_MAX);
	bsize=strlen(buf);
	bfirstchar=buf;
	isbuf=TRUE; 
    }
    else isbuf=FALSE;

    /* you need to fix the rest */

    if ((but & B_OK)==B_OK) {
	bar[bc++]=3;
	but_cols+=6;
    }
    if ((but & B_YES)==B_YES) {
	bar[bc++]=2;
	but_cols+=7;
    }
    if ((but & B_NO)==B_NO) {
	bar[bc++]=1;
	but_cols+=6;
    }
    if ((but & B_CANCEL)==B_CANCEL) {
	bar[bc++]=0;
	but_cols+=10;
    }
	
    len=strlen(message)+4;	
    if (isbuf) {len=COLS/2;wh++;}
    if ((tlen=bc*7+4)>len) len=tlen;	
    if (isbuf) {
	if (len<(bsize+4)) 

		/* setting the first visible char */
	
	bfirstchar=bfirstchar+bsize+5-len;
	bvsize=strlen(bfirstchar);	

	/* marked char */
	
	bpos=bvsize;
    }
    mw=newwin(wh,len,LINES/2-5,COLS/2-len/2);
    wbkgd(mw,COLOR_PAIR(10));
    wborder(mw,0,0,0,0,0,0,0,0);
    wattrset(mw,COLOR_PAIR(11));
    mvwprintw(mw,0,1," %s ",name);
    wattrset(mw,COLOR_PAIR(10));
    if (buf!=NULL) wmove(mw,2,2);
    else wmove(mw,2,len/2-strlen(message)/2);
    wprintw(mw,"%s",message);
    curs_set(1);
	
    keypad(mw,TRUE);
	
    do{

	/* prints the buffer contents */
	
	if (isbuf) {
	    bvsize=strlen(bfirstchar);	
	    wattrset(mw,COLOR_PAIR(2));
	    mvwprintw(mw,3,2,"%-*.*s",COLS/2-4,COLS/2-4,bfirstchar);
	    wattrset(mw,COLOR_PAIR(10)); 
	}

	but_pos=len/2-((but_cols+bc*2)/2);

	/* shows the buttons */
	
	for(tlen=0;tlen<bc;tlen++) {
	    if (bc==1) but_pos=len/2-strlen(button[bar[tlen]])/2-2;
	    wmove(mw,wh-3,but_pos);
	    if (tlen==bsel) wattrset(mw,COLOR_PAIR(2));
	    else wattrset(mw,COLOR_PAIR(10));
	    wprintw(mw,"[ %s ]",button[bar[tlen]]); 
	    but_pos+=strlen(button[bar[tlen]])+6;
	} 
	if (isbuf) wmove(mw,3,2+bpos);
	key=wgetch(mw);
		
	if (key=='\t') {
	    //if (bsel<bc-1) bsel++;
	    //else bsel=0;
	    bsel=(bsel+1)%bc;
	}		
	else if (key==KEY_RIGHT) {
	    if (bsel<bc-1) bsel++;
	    if (isbuf && bpos<bvsize) {
		bpos++;
		if (bpos>=COLS/2-4) {
		    bfirstchar=bfirstchar+1;
		    bpos--;
		}
	    }
	    //if ((bpos>=(COLS/2-1))&&((bpos-bfirstchar)==(COLS/2-4))) bfirstchar++;
	}
	else if (key==KEY_LEFT) {
	    if (bsel>0) bsel--;
	    if (isbuf) {
		if (bpos>0) bpos=bpos-1;
		else if (bfirstchar>buf) bfirstchar=bfirstchar-1;
	    }
	}
	else if (key==KEY_ESC) {
	    delwin(mw);
	    if (tbuf!=NULL) xfree(tbuf);
	    curs_set(0);
	    return B_CANCEL; 
	}
			
	else if (isbuf && (bsize<PATH_MAX)) {
	    if (key==KEY_BACKSPACE) {
		if (bpos>0) {
		    bpos--;bsize--;
		    if (bpos==bvsize) bfirstchar[bpos]='\0';//sprintf(bfirstchar+bpos,"\0");
		    else sprintf(bfirstchar+bpos,"%s",bfirstchar+bpos+1);
		} else if (bfirstchar>buf){
			bfirstchar=bfirstchar-1;
			bsize--;	    
			sprintf(bfirstchar+bpos,"%s",bfirstchar+bpos+1);
	    	}
	    }
	    
	    if (key==KEY_DC) 
		if (bsize>0) {
		    bsize--;
		    if (bpos!=bvsize) sprintf(bfirstchar+bpos,"%s",bfirstchar+bpos+1);
		}			
	    if (isascii(key) && key>'\n'/*||(key=='.')||(key==',')||(key=='/')||(key=='-')*/) {
		if (bpos==bvsize) sprintf(bfirstchar+bpos,"%c",key);
		else {
		    strcpy(tbuf,bfirstchar+bpos);
		    sprintf(bfirstchar+bpos,"%c%s",key,tbuf); 
		}
		bsize++;
		bpos++;
		if (bpos>=(COLS/2-4)) {
		    bfirstchar++; 
		    bpos--;
		}
	    }
	}
    } while(key!='\n');
    if (isbuf) xfree(tbuf);
    delwin(mw);
    curs_set(0);
    return (8>>bar[bsel]);
}

/* under heavy construction ;-) */

void funDelete(DirStruct *ds,int info)
{
    int tmp;
    
    tmp=wgetch(tmp_win);
    if (tmp=='\n') dirProcessBreak(DP_BREAK_NORMAL);
    if (info!=DP_DIRIN) {
	if (info==DP_FILE) unlink(ds->name);
	else rmdir(ds->name);
//	fprintf(stderr,"FUNDELETE: Deleting %s\n",ds->name);
	tmp=getmaxx(tmp_win)-14;
	mvwprintw(tmp_win,2,12,"%-*.*s",tmp,tmp,ds->name);
	wrefresh(tmp_win);
    }
}
int dlgDelete(OPANEL *p)
{
    tmp_win=newwin(8,40,LINES/2-5,COLS/2-20);
    wbkgd(tmp_win,COLOR_PAIR(10));
    wborder(tmp_win,0,0,0,0,0,0,0,0);
    wattrset(tmp_win,COLOR_PAIR(11));
    mvwprintw(tmp_win,0,1,"%s",strings[3]);
    mvwprintw(tmp_win,6,18-strlen(button[0])/2,"[ %s ]",button[0]);
    wattrset(tmp_win,COLOR_PAIR(10));
    mvwprintw(tmp_win,2,2,"Deleting: ");
    if (! p->sel_count) p->sel_ds->selected=1;
    nodelay(tmp_win,TRUE);
    dirProcess(p->sel_ds,&funDelete,0);    
    delwin(tmp_win);
    return 0;
}


int funRawCopy(DirStruct *srcds)
{
    FILE *srcfp,*dstfp;	

	/* source size, buffer size */
	
    size_t fsize,cbuf_size; 

	/* number of read, number of written */
	
    size_t fs_read,fd_written_all;

	/* percent bar position */
	
    int	per_pos;

	/* percent bar lenght */
	
    int pbar_lenght;
    int tmp;		

	/* buffer */
	
    char *chtmp;
    
    if (srcds==NULL) return 0;
    if (! cp_newname) sprintf(buffer,"%s/%s",buffer,srcds->name);
    else cp_newname=0;
    fsize=srcds->size;
    
    /* opening files */
    if ((srcfp=fopen(srcds->name,"r"))==NULL) return -1;
    if ((dstfp=fopen(buffer,"w"))==NULL) return -1;
    
    /* setting the buffer size */
    if (fsize<=MAX_CBUF_SIZE) cbuf_size=fsize;
    else cbuf_size=MAX_CBUF_SIZE;

	/* allocating memory for the buffer */

    while ((chtmp=(char *)xmalloc(fsize))==NULL && fsize) {

	/* if there isn't memory even for 1 byte */
	
	if (fsize==1) fsize=0;
	fsize/=2;
    }

	/* you need to add the number which means memory is missing */
	
    if (! fsize) return -1;	
    
	/* the real copying procedure */
	
    if (srcfp!=NULL && dstfp!=NULL && chtmp!=NULL) {
	fd_written_all=0;
	per_pos=getmaxx(tmp_win)-6;
	pbar_lenght=per_pos-5;
	mvwprintw(tmp_win,4,2,"|");
	mvwprintw(tmp_win,4,2+pbar_lenght+1,"|");
	do {

		/* reading from buffer */
		
	    fs_read=fread(chtmp,1,cbuf_size,srcfp);	

		/* writing to buffer */
		
	    fwrite(chtmp,1,fs_read,dstfp);
	    fd_written_all+=fs_read;	

		/* we need to adapt the percent bar */
		
	    tmp=(int)(((float)fd_written_all/(float)fsize)*(float)pbar_lenght);
	    wattrset(tmp_win,COLOR_PAIR(11));
	    mvwprintw(tmp_win,4,3,"%*.*s",tmp,tmp,"");
	    wattrset(tmp_win,COLOR_PAIR(10));

		/* percentual progress */
		
	    tmp=(int)( ( (float)fd_written_all/(float)fsize )*100.0 );

		/* writing the percents */
		
	    mvwprintw(tmp_win,4,per_pos,"%3d%%",tmp);
	    wrefresh(tmp_win);
	    //tmp=wgetch(tmp_win);

	/* copies while EOF or an error occured */
		
	} while (! feof(srcfp));

	/* clears the progress bar and the percents */
	
	mvwprintw(tmp_win,4,2,"%*.*s",per_pos+2,per_pos+2,"");
	xfree(chtmp);	
    }
    fclose(srcfp);
    fclose(dstfp);
    chmod(buffer,srcds->mode);
    chtmp=strrchr(buffer,'/');
    *chtmp='\0';
    return 0;
    
}
void funCopy(DirStruct *ds,int info)
{
    int tmp;
    char *chtmp;
    
    tmp=wgetch(tmp_win);
    if (tmp=='\n') dirProcessBreak(DP_BREAK_NORMAL);
    if (info==DP_FILE) {
	tmp=getmaxx(tmp_win)-13;
	mvwprintw(tmp_win,2,11,"%-*.*s",tmp,tmp,ds->name);
	funRawCopy(ds);
	wrefresh(tmp_win);
    }
    else if (info==DP_DIRIN) {
	if (! cp_newname) sprintf(buffer,"%s/%s",buffer,ds->name);
	else cp_newname=0;
	mkdir(buffer,ds->mode);
//	fprintf(stderr,"FUNCOPY: created/entered %s\n",buffer);
    }
    else {
	chtmp=strrchr(buffer,'/');
	*chtmp='\0';
//	fprintf(stderr,"FUNCOPY: back to %s\n",buffer);	
    }
}
int dlgCopy(OPANEL *p, char *dest)
{
    int itmp;
    

    buffer=dest;
    if (buffer==NULL) return 1;
    tmp_win=newwin(8,40,LINES/2-5,COLS/2-20);
    cp_newname=0;
    
    wbkgd(tmp_win,COLOR_PAIR(10));
    wborder(tmp_win,0,0,0,0,0,0,0,0);
    wattrset(tmp_win,COLOR_PAIR(11));
    mvwprintw(tmp_win,0,1,"%s",strings[3]);
    mvwprintw(tmp_win,6,18-strlen(button[0])/2,"[ %s ]",button[0]);
    wattrset(tmp_win,COLOR_PAIR(10));
    mvwprintw(tmp_win,2,2,"Copying: ");
    
    if (! p->sel_count) p->sel_ds->selected=1;

	/* last char in buffer */
	
    itmp=strlen(buffer)-1;
    if (buffer[itmp]=='/') buffer[itmp]='\0';

	/* if you want to copy to another filename */
	
    else if (p->sel_count==0) cp_newname=1;
    nodelay(tmp_win,TRUE);
    dirProcess(p->sel_ds,&funCopy,0);    
    if (p->sel_count==0) p->sel_ds->selected=0;
    delwin(tmp_win);
    return 0;
}
