/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class Textblock
  {
  mutable std::vector< Textline > data;

  void add_line() throw() { data.push_back( Textline() ); }
  void insert_line( int ) throw();
  void delete_line( int ) throw();

public:
  Textblock( const Charset & charset, const std::vector< Block > & block_vector ) throw();

  Textline & line( int ) const throw();
  int lines() const throw() { return data.size(); }
  int characters() const throw();

  void print( const Control & control ) const throw();
  void dprint( const Control & control, bool graph, bool recursive ) const throw();
  void xprint( const Control & control ) const throw();
  };
