/*  GNU OCRAD - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class ISO_8859_1
  {
public:
  enum code { IEXCLAM = 161,	// inverted exclamation mark
              COPY    = 169,	// copyright sign
              FEMIORD = 170,	// feminine ordinal indicator
              LDANGLE = 171,	// left-pointing double angle quotation mark
              NOT     = 172,	// not sign
              REG     = 174,	// registered sign
              DEG     = 176,	// degree sign
              PLUSMIN = 177,	// plus-minus sign
              POW2    = 178,	// superscript two
              POW3    = 179,	// superscript three
              ACUTE   = 180,	// acute accent
              MICRO   = 181,	// micro sign
              PILCROW = 182,	// pilcrow sign
              MIDDOT  = 183,	// middle dot
              POW1    = 185,	// superscript one
              MASCORD = 186,	// masculine ordinal indicator
              RDANGLE = 187,	// right-pointing double angle quotation mark
              FRACT14 = 188,	// vulgar fraction one quarter
              FRACT12 = 189,	// vulgar fraction one half
              FRACT34 = 190,	// vulgar fraction three quarters
              IQUEST  = 191,	// inverted question mark
              CAGRAVE = 192,	// latin capital letter a with grave
              CAACUTE = 193,	// latin capital letter a with acute
              CACIRCU = 194,	// latin capital letter a with circumflex
              CATILDE = 195,	// latin capital letter a with tilde
              CADIAER = 196,	// latin capital letter a with diaeresis
              CARING  = 197,	// latin capital letter a with ring above
              CCCEDI  = 199,	// latin capital letter c with cedilla
              CEGRAVE = 200,	// latin capital letter e with grave
              CEACUTE = 201,	// latin capital letter e with acute
              CECIRCU = 202,	// latin capital letter e with circumflex
              CEDIAER = 203,	// latin capital letter e with diaeresis
              CIGRAVE = 204,	// latin capital letter i with grave
              CIACUTE = 205,	// latin capital letter i with acute
              CICIRCU = 206,	// latin capital letter i with circumflex
              CIDIAER = 207,	// latin capital letter i with diaeresis
              CNTILDE = 209,	// latin capital letter n with tilde
              COGRAVE = 210,	// latin capital letter o with grave
              COACUTE = 211,	// latin capital letter o with acute
              COCIRCU = 212,	// latin capital letter o with circumflex
              COTILDE = 213,	// latin capital letter o with tilde
              CODIAER = 214,	// latin capital letter o with diaeresis
              CUGRAVE = 217,	// latin capital letter u with grave
              CUACUTE = 218,	// latin capital letter u with acute
              CUCIRCU = 219,	// latin capital letter u with circumflex
              CUDIAER = 220,	// latin capital letter u with diaeresis
              CYACUTE = 221,	// latin capital letter y with acute
              SSSHARP = 223,	// latin small letter sharp s (german)
              SAGRAVE = 224,	// latin small letter a with grave
              SAACUTE = 225,	// latin small letter a with acute
              SACIRCU = 226,	// latin small letter a with circumflex
              SATILDE = 227,	// latin small letter a with tilde
              SADIAER = 228,	// latin small letter a with diaeresis
              SARING  = 229,	// latin small letter a with ring above
              SCCEDI  = 231,	// latin small letter c with cedilla
              SEGRAVE = 232,	// latin small letter e with grave
              SEACUTE = 233,	// latin small letter e with acute
              SECIRCU = 234,	// latin small letter e with circumflex
              SEDIAER = 235,	// latin small letter e with diaeresis
              SIGRAVE = 236,	// latin small letter i with grave
              SIACUTE = 237,	// latin small letter i with acute
              SICIRCU = 238,	// latin small letter i with circumflex
              SIDIAER = 239,	// latin small letter i with diaeresis
              SNTILDE = 241,	// latin small letter n with tilde
              SOGRAVE = 242,	// latin small letter o with grave
              SOACUTE = 243,	// latin small letter o with acute
              SOCIRCU = 244,	// latin small letter o with circumflex
              SOTILDE = 245,	// latin small letter o with tilde
              SODIAER = 246,	// latin small letter o with diaeresis
              DIV     = 247,	// division sign
              SUGRAVE = 249,	// latin small letter u with grave
              SUACUTE = 250,	// latin small letter u with acute
              SUCIRCU = 251,	// latin small letter u with circumflex
              SUDIAER = 252,	// latin small letter u with diaeresis
              SYACUTE = 253,	// latin small letter y with acute
              SYDIAER = 255	// latin small letter y with diaeresis
              };

  static unsigned char base_letter( unsigned char ch ) throw();
  static unsigned char compose( unsigned char base_letter,
                                unsigned char accent ) throw();
  static bool isalnum( unsigned char ch ) throw();
  static bool isalpha( unsigned char ch ) throw();
  static bool isupper( unsigned char ch ) throw();
  static bool isvowel( unsigned char ch ) throw();
  static unsigned char toupper( unsigned char ch ) throw();
  };
