/*  GNU OCRAD - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class Bitmap;
class Block;

class Blockmap
  {
  int _height;
  int _width;
  std::vector< std::vector< int > > data;

  // List of clusters of black bits (Blocks), possibly containing
  // one or more blocks of white bits (holes).
  // The blocks are (more or less) ordered by position from top to bottom,
  // and then from left to right.
  std::list< Block > _block_list;

  Block * create_block( const Rectangle & r, int id ) throw();
  void delete_block( int id ) throw();
  Block * join_blocks( int id1, int id2 ) throw();
  Block * add_point_to_block( int row, int col, int id ) throw();

public:
  Blockmap( const Bitmap & source, int rindex, int debug_level ) throw();

  int height() const throw() { return _height; }
  int width()  const throw() { return _width;  }
  int id( int row, int col ) const throw() { return data[row][col]; }
  const std::list< Block > & block_list() const throw() { return _block_list; }

  void print( FILE * outfile, int debug_level ) const throw();
  };
