/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class Textline : public Track
  {
  Character * _big_initial;
  mutable std::vector< Character > data;

public:
  Textline() throw() : _big_initial( 0 ) {}
  Textline( const Textline & tl ) throw();
  Textline & operator=( const Textline & tl ) throw();
  ~Textline() throw() { delete_big_initial(); }
  void set_track() throw();

  const Character * big_initial() const throw() { return _big_initial; }
  void big_initial( const Character & c ) throw();
  void delete_big_initial() throw();

  void delete_character( int i ) throw();
  int  shift_character( const Character & c ) throw();
  bool insert_space( int i, bool tab = false ) throw();

  Character & character( int i ) const throw();
  int characters() const throw() { return data.size(); }

  int mean_height() const throw();
  int mean_width() const throw();
  int mean_gap_width( int max_gap_width = 0 ) const throw();
  int mean_hcenter() const throw();
  int mean_vcenter() const throw();

  void join( Textline & tl ) throw();
  void print( const Control & control ) const throw();
  void dprint( const Control & control, bool graph, bool recursive ) const throw();
  void xprint( const Control & control ) const throw();
  void cmark( Bitmap & bitmap ) const throw();

  void recognize1( const Charset & charset ) const throw();
  void recognize2( const Charset & charset ) throw();
  };
