/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class Character : public Rectangle
  {
  struct Guess
    {
    int code;
    int value;
    Guess( int c, int v ) throw() : code( c ), value( v ) {}
    };

  const Blockmap * _blockmap;	// Blockmap to which this character belongs
  std::vector< Block > _block_vector;	// the blocks forming this Character
  std::vector< Guess > _guess;		// vector of possible char codes
					// and their associated values

  void recognize11( const Charset & charset, int charbox_vcenter ) throw();
    void recognize110( const Charset & charset, int charbox_vcenter ) throw();
    void recognize111( const Charset & charset, int charbox_vcenter ) throw();
    void recognize112( int charbox_vcenter ) throw();
  void recognize12( const Charset & charset, int charbox_vcenter ) throw();
  void recognize13( const Charset & charset ) throw();

public:
  Character( const Block & b ) throw()
    : Rectangle( b ), _blockmap( b.blockmap() )
    { _block_vector.push_back( b ); }

  Character( const Rectangle & r, const Blockmap & b ) throw()
    : Rectangle( r ), _blockmap( &b ) {}

  int   area() const throw();
  Block & block( int i ) throw();
  int   blocks() const throw() { return _block_vector.size(); }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  void shift_block( const Block & b ) throw();

  void add_guess( int code, int value ) throw();
  void clear_guesses() throw() { _guess.clear(); }
  void insert_guess( int i, int code, int value ) throw();
  void delete_guess( int i ) throw();
  void only_guess( int code, int value ) throw();
  void swap_guesses( int i, int j ) throw();
  const Guess & guess( int i ) const throw();
  int guesses() const throw() { return _guess.size(); }
  bool maybe( int code ) const throw();

  void join( Character & c ) throw();
  void print( const Control & control ) const throw();
  void dprint( const Control & control, bool graph, bool recursive ) const throw();
  void xprint( const Control & control ) const throw();

  void recognize1( const Charset & charset, int charbox_vcenter ) throw();
  };
