--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class FEATURE_DEFINITION

inherit GLOBALS
        REFERENCE_COUNTER

creation make, make_from_csv


feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   type: UNSIGNED

   name: NAME

   number: INTEGER   -- number of elements, 0 = variable, > 1 array of number


   make(type_ref: UNSIGNED; fname: STRING; num_elem: INTEGER) is
      require
         not fname.has('[')
         find_feature(type_ref, fname, num_elem) = Void
      do
         reference := next_reference

         !!reference_list.make

         type := type_ref
         number := num_elem

         name := find_name(fname)

         if name = Void then
            !!name.make(fname)
         end

         name.reference_list.add_reference(reference)

         all_features.add_last(Current)

         feat_def_class_def.reference_list.add_reference(reference)
      end


   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         check_comma(line)

         type := scan_reference(line)    -- read type reference

         check_comma(line)

         dummy := scan_reference(line)   -- read name reference

         name := find_name_from_reference(dummy)

         check_comma(line)

         if line.count > 2 then
            std_error.put_string("read feature definition line too long: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end            

         if not line.item(1).is_digit then
            std_error.put_string("read feature definition - invalid digit: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         if line.count = 2 and then not line.item(2).is_digit then
            std_error.put_string("read feature definition - invalid digit: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         number := line.item(1).decimal_value

         if line.count = 2 then
           number := number * 10 + line.item(2).decimal_value
         end
      end


end

