/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2007, 2008, 2009, 2010  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2010-01-17 15:01:51 -0700 (Sun, 17 Jan 2010) $
--   $Revision: 4463 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <assert.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "crc32.h"
#include "disk_io.h"
#include "objectify.h"


static size_t get_spelling_object_size(void* spelling_obj)
{
    assert(((C_struct_Spelling*)spelling_obj)->count > 0);
    return sizeof(C_struct_Spelling) + ((C_struct_Spelling*)spelling_obj)->count;
}

#if 0
static size_t get_name_object_size(void* name_obj)
{
    assert(((C_struct_Name*)name_obj)->count > 0);
    return sizeof(C_struct_Name) + (((C_struct_Name*)name_obj)->count * sizeof(ObjRef));
}
#endif

static size_t get_class_object_size(void* class_obj)
{
    return sizeof(C_struct_Class_Definition) + (((C_struct_Class_Definition*)class_obj)->count * sizeof(ObjRef));
}



int main(int argc, char* argv[])
{
    ObjRef spelling_class_ref;
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_Class_Definition* spelling_class_ptr = (C_struct_Class_Definition*)kludge;
    C_struct_Spelling* spelling_ptr = (C_struct_Spelling*)kludge;
    ReferenceList* ref_list;
    int num_refs;
    int i;
    char spelling[64];

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(PUBLIC, NULL);


    assert(nwos_find_public_class_definition("SPELLING", &spelling_class_ref));

    printf("Spelling class reference: %02x%02x%02x%02x\n",
	   spelling_class_ref.id[0],
	   spelling_class_ref.id[1],
	   spelling_class_ref.id[2],
	   spelling_class_ref.id[3]);


    assert(nwos_read_variable_sized_object_from_disk(&spelling_class_ref, kludge, sizeof(kludge), &get_class_object_size));

    ref_list = nwos_malloc_reference_list(&spelling_class_ptr->header.object.references);
    num_refs = ref_list->common_header.num_refs;

    printf("Number of spellings: %d\n", num_refs);

    for (i = 0; i < num_refs; i++)
    {
	assert(nwos_read_variable_sized_object_from_disk(&ref_list->references[i], kludge, sizeof(kludge), &get_spelling_object_size));

	memcpy(spelling, spelling_ptr->storage, spelling_ptr->count);
	spelling[spelling_ptr->count] = '\0';

	printf("%s\n", spelling);
    }

    nwos_free_reference_list(ref_list);
    ref_list = NULL;

    nwos_terminate_objectify();

    return 0;
}

