/*
--          This file is part of the New World OS and Objectify projects
--         Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2010-06-30 07:54:24 -0600 (Wed, 30 Jun 2010) $
--   $Revision: 4661 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file, the disk_io.h file, the old log
--   from the objectify_private.h file in the disk_io.h file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#ifndef HEADER_H
#define HEADER_H

#include "time_stamp.h"
#include "types.h"


#define MAGIC_NUMBER "NWOS"

#define TYPE_CODE_COMPRESSED  "cmpr"
#define TYPE_CODE_DIFF        "diff"
#define TYPE_CODE_DISK        "disk"
#define TYPE_CODE_FILE        "file"
#define TYPE_CODE_PUBLIC      "pblc"


typedef struct {
    char magic_number[4];
    char version_string[4];
    char type_code[4];
    uint8 block_offset_to_chunks[4];

    TimeStamp last_prep_disk;
    uint8 total_chunks[4];               /* this does NOT include the chunk used by the system */
    uint8 used_chunks[4];               /* this does NOT include the chunk used by the system */

    TimeStamp last_change;
    uint8 used_blocks[8];
} Disk_Header;

typedef struct {
    char magic_number[4];
    char version_string[4];
    TimeStamp last_prep_disk;

    uint8 total_blocks[4];
    uint8 used_blocks[4];
    TimeStamp last_change;

    uint8 block_offset_to_chunks[4];
    uint8 used_chunks[4];
    uint8 unused7[4];
    uint8 unused8[4];
} Disk_Header_0022_to_0029;

typedef struct {
    char magic_number[4];
    char version_string[4];
    TimeStamp last_prep_disk;

    uint8 total_public_blocks[4];
    uint8 used_public_blocks[4];
    TimeStamp public_last_change;

    uint8 total_private_blocks[4];
    uint8 used_private_blocks[4];
    TimeStamp private_last_change;

    uint8 unused5[4];
    uint8 next_private_chunk[4];
    uint8 unused6[4];
    uint8 unused7[4];
} Disk_Header_0021;

typedef struct {
    char magic_number[4];
    char version_string[4];
    TimeStamp time_last_change;

    uint8 total_public_blocks[4];
    uint8 total_private_blocks[4];
    uint8 unused1[4];
    uint8 unused2[4];

    uint8 used_public_blocks[4];
    uint8 used_private_blocks[4];
    uint8 unused3[4];
    uint8 unused4[4];

    uint8 unused5[4];
    uint8 next_private_chunk[4];
    uint8 unused6[4];
    uint8 unused7[4];
} Disk_Header_0016_to_0020;


extern Disk_Header nwos_public_disk_header;    /* these should only be accessed by storage.c to pass to backup */
extern Disk_Header nwos_private_disk_header;

extern uint64 nwos_used_public_blocks;
extern uint64 nwos_used_private_blocks;

extern uint32 nwos_total_private_chunks;
extern uint32 nwos_used_private_chunks;
extern uint32 nwos_block_offset_to_chunks;

extern char nwos_version_string[5];
extern TimeStamp nwos_last_change;

extern const char* nwos_check_disk_header(Disk_Header* disk_header, bool compressed_file, const char* type_code);

extern const char* nwos_load_public_data(void *buffer, size_t buffer_size);
extern void nwos_store_public_data(void *buffer, size_t buffer_size);
extern const char* nwos_load_private_data(void *buffer, size_t buffer_size, bool compressed_file);
extern void nwos_store_private_data(void *buffer, size_t buffer_size, bool update_total_chunks);


#endif


