--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class SPELLING

inherit GLOBALS
        REFERENCE_COUNTER
        ANY
           redefine
              is_equal
           end

creation make, make_from_csv


feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   spelling: STRING

   make(letters: STRING) is
      do
         reference := next_reference

         !!reference_list.make

         !!spelling.copy(letters)
         spelling.to_lower

         check
            not all_spellings.has(Current)
         end

         all_spellings.add_last(Current)

         spelling_class_def.reference_list.add_reference(reference)
      end

   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         check_comma(line)

         if line.first /= '"' then
            std_error.put_string("reading spelling - missing beginning %": ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         if line.last /= '"' then
            std_error.put_string("reading spelling - missing ending %": ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         line.remove_first(1)
         line.remove_last(1)

         !!spelling.copy(line);
      end

   is_equal(other: like Current): BOOLEAN is
      do
         Result := spelling.is_equal(other.spelling)
      end

end



