/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <assert.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "../crc32.h"
#include "../objectify_private.h"


#if 0
static size_t get_spelling_object_size(void* spelling_obj)
{
    assert(((C_struct_Spelling*)spelling_obj)->count > 0);
    return sizeof(C_struct_Spelling) + ((C_struct_Spelling*)spelling_obj)->count;
}

static size_t get_name_object_size(void* name_obj)
{
    assert(((C_struct_Name*)name_obj)->count > 0);
    return sizeof(C_struct_Name) + (((C_struct_Name*)name_obj)->count * sizeof(ObjRef));
}
#endif

static size_t get_class_object_size(void* class_obj)
{
    return sizeof(C_struct_Class_Definition) + (((C_struct_Class_Definition*)class_obj)->count * sizeof(ObjRef));
}


ObjRef* byte_class_ref()
{
    static ObjRef result;

    if (is_void_reference(&result))
    {
	if (!nwos_find_public_class_definition("BYTE", &result))
	{
	    fprintf(stderr, "Could not locate BYTE class definition\n");
	    nwos_terminate_objectify();
	    exit(1);
	}

	printf("byte_class_ref: %02x%02x%02x%02x\n",
	       result.id[0],
	       result.id[1],
	       result.id[2],
	       result.id[3]);
    }

    return &result;
}


ObjRef* character_class_ref()
{
    static ObjRef result;

    if (is_void_reference(&result))
    {
	if (!nwos_find_public_class_definition("CHARACTER", &result))
	{
	    fprintf(stderr, "Could not locate CHARACTER class definition\n");
	    nwos_terminate_objectify();
	    exit(1);
	}

	printf("byte_class_ref: %02x%02x%02x%02x\n",
	       result.id[0],
	       result.id[1],
	       result.id[2],
	       result.id[3]);
    }

    return &result;
}


ObjRef* objref_class_ref()
{
    static ObjRef result;

    if (is_void_reference(&result))
    {
	if (!nwos_find_public_class_definition("OBJECT REFERENCE", &result))
	{
	    fprintf(stderr, "Could not locate OBJECT REFERENCE class definition\n");
	    nwos_terminate_objectify();
	    exit(1);
	}

	printf("object_reference_class_ref: %02x%02x%02x%02x\n",
	       result.id[0],
	       result.id[1],
	       result.id[2],
	       result.id[3]);
    }

    return &result;
}


void add_feature(C_struct_Class_Definition* class_obj_ptr, ObjRef* type, char* name, int num)
{
    int count;
    ObjRef feature_ref;

    assert(get_class_object_size(class_obj_ptr) < FILE_BLOCK_SIZE);

    count = class_obj_ptr->count;

    nwos_find_or_create_public_feature_definition(type, name, num, &feature_ref);

    copy_reference(&class_obj_ptr->feature[count], &feature_ref);

    nwos_add_to_references(&class_obj_ptr->header.common.id, &feature_ref);

    class_obj_ptr->count = count + 1;

    printf("feature: %d - %s  new size: %d\n", count, name, (int)get_class_object_size(class_obj_ptr));
}



void remove_feature(C_struct_Class_Definition* class_obj_ptr, ObjRef* type, char* name, int num)
{
    int count;
    ObjRef feature_ref;
    int i;
    int j;

    assert(get_class_object_size(class_obj_ptr) < FILE_BLOCK_SIZE);

    count = class_obj_ptr->count;

    assert(nwos_find_public_feature_definition(type, name, num, &feature_ref));

    for (i = 0; i < count; i++)
    {
	if (is_same_object(&feature_ref, &class_obj_ptr->feature[i])) break;
    }

    count--;

    if (i != count)    /* not removing the last one in the list */
    {
	for (j = i; j < count; j++)
	{
	    copy_reference(&class_obj_ptr->feature[j], &class_obj_ptr->feature[j+1]);
	}
    }

    void_reference(&class_obj_ptr->feature[count]);

    nwos_remove_from_references(&class_obj_ptr->header.common.id, &feature_ref);

    class_obj_ptr->count = count;

    printf("feature removed: %d - %s  new count: %d  new size: %d\n",
	   i, name, count, (int)get_class_object_size(class_obj_ptr));
}



int main(int argc, char* argv[])
{
    ObjRef root_ref;
    ObjRef class_ref;
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_Class_Definition* class_obj_ptr = (C_struct_Class_Definition*)kludge;

    char* class_name = "DEVICE";     /* <---- CHANGE THIS --------- */
    int old_num_features = 13;        /* <---- AND THIS --------- */

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, DEFAULT_TYPE_RW, DEFAULT_FILE);

    nwos_set_encryption_level(Encryption_None);

    printf("Updating '%s' class on: %s\n", class_name, DEFAULT_FILE);

    printf("next_reference: %02x%02x%02x%02x\n", 
	   nwos_next_public_ref.id[0],
	   nwos_next_public_ref.id[1],
	   nwos_next_public_ref.id[2],
	   nwos_next_public_ref.id[3]);

    root_ref.id[0] = 0;
    root_ref.id[1] = 0;
    root_ref.id[2] = 0;
    root_ref.id[3] = 1;

    nwos_set_root_object(&root_ref);

    if (!nwos_find_public_class_definition(class_name, &class_ref))
    {
	fprintf(stderr, "Could not locate %s class definition\n", class_name);
	nwos_terminate_objectify();
	exit(1);
    }

    printf("class_ref: %02x%02x%02x%02x\n",
	   class_ref.id[0],
	   class_ref.id[1],
	   class_ref.id[2],
	   class_ref.id[3]);

    assert(nwos_read_variable_sized_object_from_disk(&class_ref, kludge, sizeof(kludge), &get_class_object_size));

    printf("  number of features: %d\n", class_obj_ptr->count);

    if (class_obj_ptr->count != old_num_features)
    {
	fprintf(stderr, "%s class has already been changed, has more than %d features!\n",
		class_name, old_num_features);
	nwos_terminate_objectify();
    }
    else
      {
	/* going to do something tricky here to have it put the new features in certain place */

	/* features:            index old  new
	   ObjRef manufacturer;        0 ->  0
           ObjRef name                 1 ->  1
	   ObjRef model_name;          2 ->  2
	   ObjRef model_number;        3 ->  3
           ObjRef introduction date    4 ->  4
                  discontinued date          5
	   ObjRef specifications;      5 ->  6
           ObjRef specifications_url   6 ->  7
	   ObjRef manual_url;          7 ->  8
	   ObjRef component_list;      8 ->  9
	   ObjRef software_list;       9 -> 10
	   ObjRef accessories;        10 -> 11
	   ObjRef photo_url_list;     11 -> 12 
	   ObjRef online_photo_list;  12 -> 13
	*/

	copy_reference(&class_obj_ptr->feature[13], &class_obj_ptr->feature[12]);
	copy_reference(&class_obj_ptr->feature[12], &class_obj_ptr->feature[11]);
	copy_reference(&class_obj_ptr->feature[11], &class_obj_ptr->feature[10]);
	copy_reference(&class_obj_ptr->feature[10], &class_obj_ptr->feature[9]);
	copy_reference(&class_obj_ptr->feature[9],  &class_obj_ptr->feature[8]);
	copy_reference(&class_obj_ptr->feature[8],  &class_obj_ptr->feature[7]);
	copy_reference(&class_obj_ptr->feature[7],  &class_obj_ptr->feature[6]);
	copy_reference(&class_obj_ptr->feature[6],  &class_obj_ptr->feature[5]);
	/* leave hole [5] for discontinued date */

	class_obj_ptr->count = 5;
	add_feature(class_obj_ptr, objref_class_ref(), "date discontinued", 1);

	class_obj_ptr->count = 14;

	nwos_crc32_calculate((uint8*) &class_obj_ptr->header.object,
			     sizeof(ObjectHeader),
			     class_obj_ptr->header.common.header_chksum);

	nwos_crc32_calculate((uint8*) &class_obj_ptr->name,
			     get_class_object_size(class_obj_ptr) - sizeof(EveryObject),
			     class_obj_ptr->header.common.data_chksum);

	nwos_overwrite_object_to_disk(&class_ref, class_obj_ptr, get_class_object_size(class_obj_ptr));
    }

    nwos_terminate_objectify();

    return 0;
}

