--
--          This file is part of the New World OS and Objectify projects
--                        Copyright (C) 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--

class SONG_LIST

creation with_capacity

feature

   list: FIXED_ARRAY[STRING]

   rating_list: FIXED_ARRAY[CHARACTER]

   with_capacity(capacity: INTEGER) is
      do
         !!list.with_capacity(capacity)
         !!rating_list.with_capacity(capacity)
      end

   has(name: STRING): BOOLEAN is
      do
         Result := list.has(name)
      end

   add_last(name: STRING; rating: CHARACTER) is
      do
         list.add_last(name)
         rating_list.add_last(rating)
      end

   last: STRING is
      do
         Result := list.last
      end

   remove_last is
      do
         list.remove_last
         rating_list.remove_last
      end

   read_list(path: STRING): BOOLEAN is
      local
         played_list_file: TEXT_FILE_READ
         temp: STRING
      do
         !!played_list_file.connect_to(path)

         if played_list_file.is_connected then
            from
               played_list_file.read_line
            until
               played_list_file.end_of_input
            loop
               rating_list.add_last(played_list_file.last_line.first)
               played_list_file.last_line.remove_first(1)

               !!temp.copy(played_list_file.last_line)
               list.add_last(temp)

               played_list_file.read_line
            end

            played_list_file.disconnect

            Result := True
         end
      end

   write_list(path: STRING): BOOLEAN is
      local
         played_list_file: TEXT_FILE_WRITE
         i: INTEGER
         temp: STRING
      do
         !!played_list_file.connect_to(path)
         temp := string_pool.item(256)

         if played_list_file.is_connected then
            from
               i := list.lower
            until
               i > list.upper
            loop
               temp.clear
               temp.extend(rating_list.item(i))
               temp.append(list.item(i))
               played_list_file.put_line(temp)
               i := i + 1
            end

            played_list_file.disconnect

            Result := True
         end
      end

end

