--
--         This file is part of the New World OS and Objectify projects
--                       Copyright (C) 2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   This program changes the format of the ChangeLog file to something
--   more friendly for pasting into the SourceForge change log.
--
-- $Log: fix_change_log.e,v $
-- Revision 1.1  2009/04/05 12:22:57  jsedwards
-- Initial version written because of the refactoring in the Alpha_29.9 release.
--


class FIX_CHANGE_LOG

creation make

feature

   make is
      local
         input_line, output_line: STRING
      do
         !!input_line.make(80)
         !!output_line.make(1024)

         from
            std_input.read_line_in(input_line)
         until
            std_input.end_of_input
         loop
             if input_line.is_empty then              -- flush
                if not output_line.is_empty then
                   std_output.put_string(output_line)
                   std_output.put_new_line
                   output_line.clear
                end

                std_output.put_new_line
                output_line.clear
             elseif input_line.has_prefix("%T") then  -- fix it up
               input_line.remove_first(1)

               if input_line.has_prefix("*") or else input_line.has_prefix("(") then
                  std_output.put_string(output_line)
                  std_output.put_new_line

                  output_line.copy("    ")
                  output_line.append(input_line)
               else
                  output_line.append(" ")
                  output_line.append(input_line)
               end
            else                                       -- date line
               if not output_line.is_empty then
                  std_output.put_string(output_line)
                  std_output.put_new_line
                  output_line.clear
               end

               std_output.put_string(input_line)
               std_output.put_new_line
            end

            std_input.read_line_in(input_line)
         end

         if not output_line.is_empty then
            std_output.put_string(output_line)
            std_output.put_new_line
         end
      end

end

