/*
--             This file is part of the New World OS project
--                    Copyright (C) 2007 QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: add_more_names.c,v $
-- Revision 1.7  2009/06/13 11:47:36  jsedwards
-- Merged changes from Alpha_29.10 branch (version Alpha_29.11).
--
-- Revision 1.6.6.2  2009/05/23 03:54:11  jsedwards
-- Changed to add 14 new names.
--
-- Revision 1.6.6.1  2009/05/22 12:09:50  jsedwards
-- Changed include of objectify_private.h to objectify.h, removed root object
-- stuff (now done by initialize function), and changed to new initialize
-- objectify calling conventions.
--
-- Revision 1.6  2007/07/29 17:41:37  jsedwards
-- Changed to add a few more girls names.
--
-- Revision 1.5  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.4  2007/06/05 12:38:43  jsedwards
-- Changed to add a bunch more names.
--
-- Revision 1.3  2007/05/20 14:35:36  jsedwards
-- Added some V through Z names.
--
-- Revision 1.2  2007/05/05 14:07:10  jsedwards
-- Changed to add some other names.
--
-- Revision 1.1  2007/05/05 12:42:01  jsedwards
-- Initial version.
--
*/

/* This program adds names to the public objects. */


#include <stdio.h>

#include "../objectify.h"



static char* extra_names[] = 
{
  "barack", "birchard", "chip", "chipp", "cunningham", "delano", "elder",
  "griffin", "harding", "hilary", "hussein", "ida", "hiram", "obama"
};


#define NUM_EXTRA_NAMES (sizeof(extra_names) / sizeof(char*))



int main(int argc, char* argv[])
{
    int i;
    ObjRef ref;
    char msg[128];


    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(PUBLIC, NULL);

    for (i = 0; i < NUM_EXTRA_NAMES; i++)
    {
	snprintf(msg, sizeof(msg), "Creating name: %s", extra_names[i]);
	nwos_log(msg);

	nwos_create_name(extra_names[i], &ref);
    }

    nwos_terminate_objectify();

    return 0;
}

