/*
--             This file is part of the New World OS project
--                 Copyright (C) 2007-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: add_password.c,v $
-- Revision 1.15  2009/06/30 13:40:46  jsedwards
-- Add include of new header.h file.
--
-- Revision 1.14  2009/06/13 11:37:25  jsedwards
-- Merged changes from Alpha_29.10 branch (version Alpha_29.11).
--
-- Revision 1.13.2.2  2009/06/07 15:01:57  jsedwards
-- Add comments about opening archive.  NO code changes!!
--
-- Revision 1.13.2.1  2009/06/07 02:28:19  jsedwards
-- Changed to not check for disk full if the archive is a file.
--
-- Revision 1.13  2009/03/13 12:06:46  jsedwards
-- Added include of objectify.h to define nwos_create_root function.
--
-- Revision 1.12  2009/03/08 00:06:17  jsedwards
-- Changed include objectify_private.h to disk_io.h.
--
-- Revision 1.11  2008/09/01 18:25:56  jsedwards
-- Changed to just verify there are chunks available and then call
-- nwos_create_root which now does all of the heavy lifting.
--
-- Revision 1.10  2008/08/31 17:58:25  jsedwards
-- Add assert around call to nwos_read_object_from_disk because it now returns
-- false when it fails, whereas before it would assert itself.
--
-- Revision 1.9  2008/08/30 12:46:05  jsedwards
-- Removed code and variables to read pass phrase and pass it to initialize,
-- and change parameters passed to initialize.
--
-- Revision 1.8  2008/02/03 01:00:15  jsedwards
-- Changed DEFAULT_TYPE_RW to READ_WRITE.
--
-- Revision 1.7  2007/10/07 03:43:50  jsedwards
-- Renamed 'nwos_set_block_estimate' to 'nwos_check_blocks_available' and
-- changed to exit gracefully if not enough space available.
--
-- Revision 1.6  2007/09/02 19:47:25  jsedwards
-- Added call to set the block estimate.
--
-- Revision 1.5  2007/08/13 00:34:51  jsedwards
-- Add call to allocate the chunk for the new password.
--
-- Revision 1.4  2007/08/12 20:45:00  jsedwards
-- Change all of the "Encryption Level" stuff to "Security Level" because it
-- doesn't really change the encryption at all, all it does is change the
-- randomization of where objects are stored.
--
-- Revision 1.3  2007/07/01 19:44:11  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.2  2007/02/11 16:58:26  jsedwards
-- Changed so DEFAULT_TYPE has to specify RO (Read-Only) or RW (Read-Write).
--
-- Revision 1.1  2007/01/17 13:57:11  jsedwards
-- Temporary kludge to add a pass phrase to existing system.
--
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "disk_io.h"     /* define nwos_initialize_disk_io and nwos_terminate_disk_io */
#include "header.h"      /* define nwos_total_private_chunks and nwos_used_private_chunks */
#include "objectify.h"   /* define nwos_create_root */


int main(int argc, char* argv[])
{
    printf("\n");

    nwos_log_arguments(argc, argv);

    nwos_initialize_disk_io(READ_ONLY, DEFAULT_FILE);	/* open read only because we are just checking space available */

    /* We are likely going to need to allocate a whole new chunk */

    if (nwos_archive_is_block_device() && nwos_total_private_chunks == nwos_used_private_chunks)
    {
	fprintf(stderr, "No more chunks available, password cannot be created\n");
	nwos_terminate_disk_io();
	exit(1);
    }

    nwos_terminate_disk_io();

    nwos_create_root();   /* this will open archive read-write */

    return 0;
}

