#
#          This file is part of the New World OS and Objectify projects
#                     Copyright (C) 2009, 2010  QRW Software
#               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program, in the file LICENSE.  If not, see 
#   <http://www.gnu.org/licenses/>.
#
#   For the latest information, source code (SVN), releases, and bug tracking
#   go to:
#      http://savannah.nongnu.org/projects/objectify
#
#   For releases from Alpha_30 and up, bug and feature request tracking go to:
#      http://sourceforge.net/projects/objectify
#
#   For older bug tracking, releases and source code (CVS) prior to the
#   Alpha_30 release go to:
#      http://sourceforge.net/projects/nwos
#
#   Other related websites:
#      http://www.qrwsoftware.com
#      http://www.worldwide-database.org
#
#   You can also contact me via paper mail at:
#
#      QRW Software
#      P.O. Box 27511
#      Salt Lake City, UT 84127-0511, USA.
#
#   $Author: jsedwards $
#   $Date: 2010-01-30 08:57:28 -0700 (Sat, 30 Jan 2010) $
#   $Revision: 4510 $
#
#   NOTE: Subversion does not support the Log keyword so I have removed the
#   logs that were here when I was using CVS.  Use the "svn log" command to
#   see the revision history of this file.
#   (See http://subversion.tigris.org/faq.html#log-in-source)
# 


export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Remove Files Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=/tmp/objectify_test

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/test directory"
   echo ""
   exit 1
fi

mkdir /tmp/test
cd /tmp/test


echo "------------------"
echo " prep..."
echo "------------------"

echo $OBJECTIFY_PRIVATE_PATH

if ! $EXEC/src/apps/util/archive-prep; then
   echo ""
   echo "archive-prep failed"
   echo ""
   exit 1
fi

sleep 1

echo "---------------------"
echo " creating files..."
echo "---------------------"

mkdir dir-1

for ((num=1; num<250; num++)) do
    echo "File: $num" >> dir-1/file-$num.txt
done

if ! $EXEC/src/apps/file/file-import --very-low-security -r dir-1/; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/file-verify --remove-no-shred -r dir-1/; then
   echo ""
   echo "file-verify failed"
   echo ""
   exit 1
fi


for ((num=0; num<200; num++)); do
    echo "**********************************"
    file=`file-list | $EXEC/src/attic/random_line`
    echo $file;

    if ! $EXEC/src/apps/util/archive-compress compressed-$num; then
       echo ""
       echo "archive-compress failed"
       echo ""
       exit 1
    fi

    if ! $EXEC/src/apps/file/file-remove --all-traces $file; then
       echo ""
       echo "file-remove failed"
       echo ""
       exit 1
    fi

    if file-export "*"; then
       if ! $EXEC/src/apps/file/file-verify --remove-no-shred -r dir-1/; then
          echo ""
          echo "file-verify failed"
          echo ""
          exit 1
       fi

       if [ -d dir-1 ]; then
          echo ""
          echo "file-verify --remove failed to remove dir-1"
          echo ""
          exit 1
       fi
    else
       echo ""
       echo "file-export failed"
       echo ""
       exit 1
    fi
done
