--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.1  2006/04/09 03:36:22  jsedwards
-- Initial version.
--


-- App to convert the 12 hex digits back into a text word (for testing)

class DECODE_WORD

creation make

feature

   make is
      local
         word: INTEGER
         bits: INTEGER
         byte: BIT 32
         input: INTEGER
         line: STRING
      do
         if argument_count /= 0 then
            std_error.put_string("usage: ")
            std_error.put_string(argument(0))
            std_error.put_string(" < 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX%N")
            die_with_code(exit_failure_code)
         end

         from
            !!line.make(80)
            std_input.read_line_in(line)
         until
            line.count = 0
         loop
            line.remove_leading_spaces

            if line.has_prefix("0x") then
               line.remove_prefix("0x")
               input := input + 1
            end

            word := word * 16
            bits := bits + 4

            check
               bits < 10
               word < 1024
            end

            inspect
               line.first
            when '0'..'9' then
               word := word + line.first.code - ('0').code
            when 'A'..'F' then
               word := word + line.first.code - ('A').code + 10
            when 'a'..'f' then
               word := word + line.first.code - ('a').code + 10
            end

            line.remove_first(1)
                        
            if line.count > 0 and then line.first = ',' then
               line.remove_first(1)
            end

            if bits >= 5 then
               bits := bits - 5
               if bits = 0 then
                  byte := word.to_bit
               else
                  byte := word.to_bit @>> bits
               end

               if byte.all_cleared then
                  std_output.put_character('_')
               else
                  std_output.put_character((byte.to_integer + ('a').code - 1).to_character)
               end

               if bits = 0 then
                  word := 0
               else
                  word := word \\ (2 ^ bits)
               end
            end
         end

         std_output.put_new_line
      end

end

