/*
--          This file is part of the New World OS and Objectify projects
--            Copyright (C) 2004, 2005, 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  Since this file was originally
--   copied from the file in the root directory I have left the CVS log from
--   that file below.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.4  2006/11/11 12:01:01  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.3  2006/11/04 18:51:07  jsedwards
-- Made a #define in the config.h file for the log file.
--
-- Revision 1.2  2006/10/26 01:51:26  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.1.2.6  2006/10/22 13:07:11  jsedwards
-- Removed BLOCKS_ON_DISK define, it is now a variable read from disk.
--
-- Revision 1.1.2.5  2006/10/03 12:51:57  jsedwards
-- Added enumeration of different storage types and a define for default type.
--
-- Revision 1.1.2.4  2006/10/02 01:23:39  jsedwards
-- Added definition of maximum blocks cached.
--
-- Revision 1.1.2.3  2006/09/26 13:18:22  jsedwards
-- Removed OBJECT_DIRECTORY and COMPATIBLE_VERSIONS definitions as they are
-- no longer used.  Added DEFAULT_FILE (which is now the disk drive or
-- partition) from objectify_private.h.  Also added the disk or partition
-- size definition.
--
-- Revision 1.1.2.2  2006/09/02 15:12:16  jsedwards
-- Moved FILE_BLOCK_SIZE back to objectify.h because now that we are storing
-- all the objects in one large, sparse file, it is no longer really the file
-- block size, it is now the size of each object written to the file.
--
-- Revision 1.1.2.1  2006/08/19 12:46:49  jsedwards
-- Moved configuration defines out of objectify.h and into a new file config.h.
--
*/


#ifndef CONFIG_H
#define CONFIG_H

typedef enum {
  Drive_Or_Partition_RO = 0,
  Drive_Or_Partition_RW,
  Sparse_File_RO,
  Sparse_File_RW,
  Compressed_File_RO,
  Compressed_File_RW
} StorageType;


#define HEADER_VERSION "\0\0\0\0"

#define DEFAULT_TYPE Drive_Or_Partition_RO
#define DEFAULT_FILE "/dev/xyzzy"

#define LOG_FILE_PATH "export_0014_to_csv_log.txt"

#define MAX_BLOCKS_CACHED 65536    // use up to 16 mb of ram for caching blocks


#endif
