/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-04 07:34:21 -0600 (Tue, 04 Aug 2009) $
--   $Revision: 4265 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "disk_io.h"     /* define nwos_initialize_disk_io and nwos_terminate_disk_io */
#include "header.h"      /* define nwos_total_private_chunks and nwos_used_private_chunks */
#include "objectify.h"   /* define nwos_create_root */


int main(int argc, char* argv[])
{
    printf("\n");

    nwos_log_arguments(argc, argv);

    nwos_initialize_disk_io(READ_ONLY, DEFAULT_FILE);	/* open read only because we are just checking space available */

    /* We are likely going to need to allocate a whole new chunk */

    if (nwos_archive_is_block_device() && nwos_total_private_chunks == nwos_used_private_chunks)
    {
	fprintf(stderr, "No more chunks available, password cannot be created\n");
	nwos_terminate_disk_io();
	exit(1);
    }

    nwos_terminate_disk_io();

    nwos_create_root();   /* this will open archive read-write */

    return 0;
}

