/*
--          This file is part of the New World OS and Objectify projects
--         Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-04 05:12:48 -0600 (Tue, 04 Aug 2009) $
--   $Revision: 4252 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file, the gen_id.h file, the disk_io.h
--   file, and the objectify_private.h file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#ifndef STORAGE_H
#define STORAGE_H

#include "reference.h"
#include "types.h"


extern void nwos_initialize_storage(AccessType type, const char* path);
extern void nwos_terminate_storage(void);

extern bool nwos_storage_is_public_only(void);
extern bool nwos_storage_is_compressed_file(void);
extern bool nwos_storage_is_read_write(void);

extern void nwos_flush_storage(void);

extern bool nwos_read_block(ObjRef* ref, uint8* block);          /* Note: this assumes that block is FILE_BLOCK_SIZE */
extern void nwos_write_block(ObjRef* ref, uint8* block);         /* Note: this assumes that block is FILE_BLOCK_SIZE */
extern void nwos_erase_block(ObjRef* ref);

#endif

