/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-04 05:12:48 -0600 (Tue, 04 Aug 2009) $
--   $Revision: 4252 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revisions of this file, the objectify.h file, and the disk_io.h
--   file which this file was created from.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#ifndef GEN_ID_H
#define GEN_ID_H

#include "reference.h"


typedef enum { Security_None=0, Security_Minimal, Security_Very_Low, Security_Low, Security_Medium, Security_High, Security_Extreme } Security_Level;

extern ObjRef nwos_next_public_ref;

extern void nwos_initialize_gen_id(void);
extern void nwos_terminate_gen_id(void);

#ifdef CHANGE_SECURITY_TO_DENSITY
extern void nwos_set_security_level(Security_Level);
extern void nwos_restart_id_generation();
#endif

extern void nwos_generate_new_public_id(ObjRef* ref);
extern void nwos_generate_new_id(ObjRef* ref);
extern void nwos_generate_new_private_id(ObjRef* ref);

extern bool nwos_check_blocks_available(uint32 estimated_blocks);

#endif

