/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.4  2006/04/09 03:29:32  jsedwards
-- Added "const" qualifier to "reference" parameter.
--
-- Revision 1.3  2006/04/08 13:32:50  jsedwards
-- Added maximum path length define and comment after endif.
--
-- Revision 1.2  2006/03/25 14:36:10  jsedwards
-- Include types.h for uint8.
--
-- Revision 1.1  2006/03/10 14:21:08  jsedwards
-- Initial version.
--
*/

#ifndef REFERENCE_H
#define REFERENCE_H

#include "types.h"

#define NWOS_PATH_MAX 128   /* for the time being */

typedef uint8 reference[16];

extern void nwos_ref_to_path(const reference ref, char path[NWOS_PATH_MAX]);


#endif /* REFERENCE_H */
