/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.2  2006/11/11 12:01:03  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.1  2006/01/22 20:49:18  jsedwards
-- Run once app to create the english letters and associated ascii letters.
--
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>   /* define memset */
#include <stdlib.h>

#include "objectify.h"
#include "c_structs.h"
#include "objectify_private.h"


#define LAST_BYTE_OBJ_REF (sizeof(ObjRef)-1)

int main()
{
    C_struct_Character char_object;
    C_struct_Letter letter_object;
    ObjRef lower_ref;
    ObjRef upper_ref;
    ObjRef letter_ref;     /* the reference for the english letter objects */
    int i;

    printf("Creating 52 (upper and lower case) ASCII letter objects...\n");

    nwos_copy_reference(lower_ref, Ascii_Chars_Ref);
    nwos_copy_reference(upper_ref, Ascii_Chars_Ref);
    nwos_copy_reference(letter_ref, English_Letters_Ref);

    for (i = 0; i < 26; i++)
    {
	upper_ref[LAST_BYTE_OBJ_REF] = Ascii_Chars_Ref[LAST_BYTE_OBJ_REF] + 'A' + i;
	lower_ref[LAST_BYTE_OBJ_REF] = Ascii_Chars_Ref[LAST_BYTE_OBJ_REF] + 'a' + i;
	letter_ref[LAST_BYTE_OBJ_REF] = English_Letters_Ref[LAST_BYTE_OBJ_REF] + i;

	memset(&char_object, 0, sizeof(char_object));

	nwos_fill_in_any(&char_object.any, Upper_Char_Class_Ref, User_Ref, Create_English_Letters_Ref);

	nwos_copy_reference(char_object.character, letter_ref);

	nwos_copy_reference(char_object.character_sets[0], Ascii_Char_Set_Ref);

	nwos_write_public_object_to_disk(upper_ref, &char_object, sizeof(char_object));

      /* same thing for lower case letters */

	memset(&char_object, 0, sizeof(char_object));

	nwos_fill_in_any(&char_object.any, Lower_Char_Class_Ref, User_Ref, Create_English_Letters_Ref);

	nwos_copy_reference(char_object.character, letter_ref);

	nwos_copy_reference(char_object.character_sets[0], Ascii_Char_Set_Ref);

	nwos_write_public_object_to_disk(lower_ref, &char_object, sizeof(char_object));

      /* finally do the english letters */

	memset(&letter_object, 0, sizeof(letter_object));

	nwos_fill_in_any(&letter_object.any, Letter_Class_Ref, User_Ref, Create_English_Letters_Ref);

	nwos_copy_reference(letter_object.alphabet, English_Alphabet_Ref);

	nwos_copy_reference(letter_object.lower_case, lower_ref);
	nwos_copy_reference(letter_object.upper_case, upper_ref);

	nwos_write_public_object_to_disk(letter_ref, &letter_object, sizeof(letter_object));
    }

    printf("Done!\n");

    return 0;
}

